CREATE TABLE IF NOT EXISTS public."FlexibleTables"
(
    "Id" bigserial NOT NULL,
    "Name" character varying(1000) NOT NULL,
    "CustomerId" integer NOT NULL,
    "Description" text,
    "OwnerId" bigint NOT NULL,
    "Type" integer NOT NULL DEFAULT 0,
    "Status" integer NOT NULL DEFAULT 1,
    "Timestamp" timestamp without time zone NOT NULL DEFAULT timezone('utc'::text, now()),
    CONSTRAINT "FlexibleTables_pkey" PRIMARY KEY ("Name", "CustomerId")
);

CREATE INDEX IF NOT EXISTS "IDX_FlexibleTables-OwnerId-Id"
    ON public."FlexibleTables" USING btree
    ("OwnerId" ASC NULLS LAST,"Id" ASC NULLS LAST)
    TABLESPACE pg_default;
