CREATE TABLE public."Groups" (
    "Id" bigserial,
    "Name" character varying(400) NOT NULL,
    "EntityType" integer NOT NULL,
    "CustomerId" integer NOT NULL,
    "OwnerId" bigint NOT NULL,
    "Color" character varying(10),
    "ParentId" bigint,
    "CreatedAt" timestamp without time zone DEFAULT timezone('utc', now())  NOT NULL,
    CONSTRAINT "Groups_pkey" PRIMARY KEY ("EntityType","CustomerId", "Name")

); 

  
CREATE INDEX IF NOT EXISTS "IDX_Groups-Id-OwnerId-ParentId"
    ON public."Groups" USING btree
    ("Id" ASC NULLS LAST, "OwnerId" ASC NULLS LAST, "ParentId" ASC NULLS LAST)
    TABLESPACE pg_default;

CREATE INDEX IF NOT EXISTS "IDX_Groups-CustomerId-EntityType"
    ON public."Groups" USING btree
    ("CustomerId" ASC NULLS LAST, "EntityType" ASC NULLS LAST)
    TABLESPACE pg_default;