#!/bin/bash

DB_HOST=$(grep -oP "host=[^\";]*" /etc/dovecot/dovecot-pgsql.conf | head -1 | cut -d'=' -f2 | cut -d' ' -f1)
DB_USER=$(grep -oP "user=[^\";]*" /etc/dovecot/dovecot-pgsql.conf | head -1 | cut -d'=' -f2 | cut -d' ' -f1)
DB_PASS=$(grep -oP "password=[^\";]*" /etc/dovecot/dovecot-pgsql.conf | head -1 | cut -d'=' -f2 | cut -d' ' -f1)
DB_NAME=$(grep -oP "dbname=[^\";]*" /etc/dovecot/dovecot-pgsql.conf | head -1 | cut -d'=' -f2 | cut -d' ' -f1)
DB_PORT=5432

EMAIL=$1

function check_email {
    # Проверяем на правильность формата (учетная запись должна быть в виде email)
    if ! [[ "$EMAIL" =~ ^[A-Za-z0-9._%+]+@[A-Za-z0-9.-]+\.[A-Za-z]{2,}$ ]]; then
        echo "Адрес $EMAIL указан не верно"
        return 1
    fi

    # Проверяем на наличие в базе
    result=$(psql -h $DB_HOST -U $DB_USER -d $DB_NAME -p $DB_PORT -t -c "SELECT COUNT(*) FROM virtual_users WHERE email='$EMAIL'")
    if [ "$result" -gt 0 ]; then
        echo "Email $EMAIL существует в базе"
    else
        echo "Email $EMAIL не существует в базе"
    fi
}

check_email