#!/bin/bash

DB_HOST=$(grep -oP "host=[^\";]*" /etc/dovecot/dovecot-pgsql.conf | head -1 | cut -d'=' -f2 | cut -d' ' -f1)
DB_USER=$(grep -oP "user=[^\";]*" /etc/dovecot/dovecot-pgsql.conf | head -1 | cut -d'=' -f2 | cut -d' ' -f1)
DB_PASS=$(grep -oP "password=[^\";]*" /etc/dovecot/dovecot-pgsql.conf | head -1 | cut -d'=' -f2 | cut -d' ' -f1)
DB_NAME=$(grep -oP "dbname=[^\";]*" /etc/dovecot/dovecot-pgsql.conf | head -1 | cut -d'=' -f2 | cut -d' ' -f1)
DB_PORT=5432

PASSWORD_MIN_LENGTH=8

NEW_USER=$1
NEW_PWD=$2

function check_mailbox {
    # Проверяем на наличие в базе
    result=$(psql -h $DB_HOST -U $DB_USER -d $DB_NAME -p $DB_PORT -t -c "SELECT COUNT(*) FROM virtual_users WHERE email='$1'")
    if [ "$result" -gt 0 ]; then
        echo "Почтовый ящик уже существует"
        return 1
    fi

    # Проверяем на правильность формата (учетная запись должна быть в виде email)
    if ! [[ "$1" =~ ^[A-Za-z0-9._%+-]+@[A-Za-z0-9.-]+\.[A-Za-z]{2,}$ ]]; then
        echo "Адрес $1 указан не верно"
        return 1
    fi
}

function check_password {
    # Проверка сложности на количество символов
    length=${#1}
    if [ "$length" -lt "$PASSWORD_MIN_LENGTH" ]; then
        echo "Пароль должен быть более $PASSWORD_MIN_LENGTH символов"
        return 1
    fi

    # Проверка сложности на наличие цифр и букв
    if ! [[ "$1" =~ [0-9] && "$1" =~ [A-Za-z] ]]; then
        echo "Пароль должен содержать буквы и цифры"
        return 1
    fi
}

function create_mailbox {
    # Проверка учетной записи на наличие в базе и правильность формата
    NEW_USER=$(echo "$NEW_USER" | tr '[:upper:]' '[:lower:]')  # Переводим email в нижний регистр
    if ! check_mailbox "$NEW_USER"; then
        return 1
    fi

    # Проверка пароля на сложность
    if ! check_password "$NEW_PWD"; then
        return 1
    fi

    # Извлекаем домен из email
    domain=$(echo "$NEW_USER" | awk -F'@' '{print $2}')

    # Получаем ID домена из таблицы virtual_domains
    domain_id=$(psql -h $DB_HOST -U $DB_USER -d $DB_NAME -p $DB_PORT -t -c "SELECT id FROM virtual_domains WHERE name='$domain'")

    if [ -z "$domain_id" ]; then
        echo "Домен не найден"
        return 1
    fi

    # Создаем почтовую учетную запись с привязкой к конкретному домену
    password_hash=$(sudo doveadm pw -s 'ssha512' -p "$NEW_PWD")
    if psql -h $DB_HOST -U $DB_USER -d $DB_NAME -p $DB_PORT -c "INSERT INTO virtual_users (domain_id, password, email) VALUES ('$domain_id', '$password_hash', '$NEW_USER')"; then
        echo "Учетная запись создана"
    else
        echo "Ошибка SQL-запроса"
        return 1
    fi
}

create_mailbox
