#!/bin/bash

DB_HOST=$(grep -oP "host=[^\";]*" /etc/dovecot/dovecot-pgsql.conf | head -1 | cut -d'=' -f2 | cut -d' ' -f1)
DB_USER=$(grep -oP "user=[^\";]*" /etc/dovecot/dovecot-pgsql.conf | head -1 | cut -d'=' -f2 | cut -d' ' -f1)
DB_PASS=$(grep -oP "password=[^\";]*" /etc/dovecot/dovecot-pgsql.conf | head -1 | cut -d'=' -f2 | cut -d' ' -f1)
DB_NAME=$(grep -oP "dbname=[^\";]*" /etc/dovecot/dovecot-pgsql.conf | head -1 | cut -d'=' -f2 | cut -d' ' -f1)
DB_PORT=5432
MAIL_DIR="/mail"

function remove_domain {
    # Проверка наличия домена в таблице
    DOMAIN=$1
    if [ -z "$DOMAIN" ]; then
        echo "Домен не указан"
        return 1
    fi

    DOMAIN=$(echo "$DOMAIN" | tr '[:upper:]' '[:lower:]')  # Переводим домен в нижний регистр

    result=$(psql -h $DB_HOST -U $DB_USER -d $DB_NAME -p $DB_PORT -t -c "SELECT COUNT(*) FROM virtual_domains WHERE name='$DOMAIN'")
    if [ "$result" -eq 0 ]; then
        echo "Домен не существует"
        return 1
    fi

    # Удаляем учетные записи для домена из таблицы virtual_users
    psql -h $DB_HOST -U $DB_USER -d $DB_NAME -p $DB_PORT -c "DELETE FROM virtual_users WHERE email LIKE '%$DOMAIN'";

    # Удаляем домен из таблицы virtual_domains
    if psql -h $DB_HOST -U $DB_USER -d $DB_NAME -p $DB_PORT -c "DELETE FROM virtual_domains WHERE name='$DOMAIN'"; then
        echo "Домен удален из базы данных"
    else
        echo "Ошибка SQL-запроса"
        return 1
    fi

    # Удаляем настройки для домена из файлов с opendkim
    sed -i "/$DOMAIN/d" /etc/opendkim/TrustedHosts
    sed -i "/$DOMAIN/d" /etc/opendkim/KeyTable
    sed -i "/$DOMAIN/d" /etc/opendkim/SigningTable
    rm -rf "/etc/opendkim/keys/$DOMAIN"

    # Удаляем директорию с почтой
    rm -rf "$MAIL_DIR/$DOMAIN"

    # Перезапуск сервисов
    systemctl restart opendkim
    systemctl restart postfix

    echo "Домен успешно удален"
}

remove_domain "$1"