#!/bin/bash

hostname=""
ip_mail=""
secret_postfix=""
secret_mysql=""
spamassassin="not_install_spamassassin"
openDKIMinstall="false"

MAKEHTTPS=$MAKE_HTTPS
echo "MAKEHTTPS=$MAKEHTTPS"
CDDISK_DOMAIN=$SITE_DOMAIN
echo "CDDISK_DOMAIN=$CDDISK_DOMAIN"
echo "DB_USER=$DB_USER"
DB_NAME="cddisk"
echo "DB_NAME=$DB_NAME"
echo "DB_HOST=$DB_HOST"

fn_read_params_postgresql()
{
    hostname_in=$(whiptail --inputbox "Введите название mx записи:" 10 60 "mx" 3>&1 1>&2 2>&3)
    hostname_status=$?
    if [ $hostname_status -eq 0 ]; then
	hostname="$hostname_in.$CDDISK_DOMAIN"
	echo "hostname: $hostname"
	hostnamectl set-hostname "$hostname"
	systemctl restart systemd-hostnamed

	ip_mail=$(whiptail --inputbox "Введите IP адрес почтового сервера:" 10 60 3>&1 1>&2 2>&3)
	ip_mail_status=$?
	if [ $ip_mail_status -eq 0 ]; then
	    echo -e "\n$ip_mail $hostname_in $hostname" >> /etc/hosts
	    secret_postfix=$(whiptail --passwordbox "Введите пароль для postfix в почтовой БД PostgreSQL:" 10 60 3>&1 1>&2 2>&3)
	    secret_postfix_status=$?
	    if [ $secret_postfix_status -eq 0 ]; then
		spamassassin_choice=$(whiptail --title "Установка SpamAssassin" --menu "Выберите опцию установки SpamAssassin:" 15 60 4 \
                "1" "Установить SpamAssassin" \
                "2" "Не устанавливать SpamAssassin" 3>&1 1>&2 2>&3)
		spamassassin_status=$?
		if [ $spamassassin_status -eq 0 ]; then
		    if [ "$spamassassin_choice" == "1" ]; then
			spamassassin="install_spamassassin"
		    else
			spamassassin="not_install_spamassassin"
		    fi
		else
		    whiptail --msgbox "Выбор установки SpamAssassin отменен. Установка прервана." 10 60
		fi

		if whiptail --yesno "Установить OpenDKIM?" 10 60; then
		    openDKIMinstall="true"
		fi

	    else
		echo "Ввод пароля для postfix отменен. Установка прервана"
		exit 1
	    fi
	else
	    echo "Ввод IP адреса почтового сервера отменен. Установка прервана"
	    exit 1
	fi
    else
	echo "Ввод hostname отменен. Установка прервана"
    exit 1
fi
}

fn_install_mail_postgresql()
{
data_today=$(date '+%d_%M_%Y')
hostname_var=$(cat /etc/hostname)
domain_name=$(echo "$hostname_var" | cut -d'.' -f2-)
db_postfix=postfix
redhat_ver=blank
this_astra=0
distr=blank

# set config dir
dir_mail=/mail
dir_postfix=/etc/postfix
dir_dovecot=/etc/dovecot
dir_www=/var/www/html
dir_spam=/etc/spamassassin
dir_log_dovecot=/var/log/dovecot
dir_etc_postfix=/var/spool/postfix/etc
dir_def=/etc/default
dir_install=./

# OS version detection
if dpkg --help &> /dev/null; then
    distr=deb
    if [ -e /etc/astra_version ]; then
        this_astra=1
    fi
elif rpm --help &> /dev/null; then
    if apt-get --help &> /dev/null; then
        distr=alt
    else
        distr=rpm
        if [[ "$(cat /etc/redhat-release)" == *"Stream"* ]]; then
            redhat_ver=centos
        elif [[ "$(cat /etc/redhat-release)" == *"MUROM"* ]]; then
            redhat_ver=redos
        fi
    fi
fi

# install bzip2
if [ $distr = deb ]; then
    if aptitude search '~i bzip2' &> /dev/null; then
        echo ""
    else
        apt update && apt install bzip2 -y
    fi
elif [ $distr = rpm ]; then
    if rpm -q bzip &> /dev/null; then
        echo ""
    else
        dnf install bzip2 -y
    fi
elif [ $distr = alt ]; then
    if rpm -q bzip &> /dev/null; then
        echo ""
    else
        apt-get install bzip2 -y
    fi
fi

# install tar
if [ $distr = deb ]; then
    if aptitude search '~i tar' &> /dev/null; then
        echo ""
    else
        apt update && apt install tar -y
    fi
elif [ $distr = rpm ]; then
    if rpm -q tar &> /dev/null; then
        echo ""
    else
        dnf install tar -y
    fi
elif [ $distr = alt ]; then
    if rpm -q tar &> /dev/null; then
        echo ""
    else
        apt-get install tar -y
    fi
fi

# unzipping the archive
if [ $distr = deb ]; then
    tar xvjf mailserver/deb-config.tar.bz2 -C $dir_install
elif [ $distr = rpm ]; then
    tar xvjf rpm-config.tar.bz2 -C $dir_install
fi

# install mariadb, nginx
if [ $distr = deb ]; then
#    if [ $this_astra = 1 ]; then
#        echo "deb https://dl.astralinux.ru/astra/stable/1.7_x86-64/repository-extended/ 1.7_x86-64 main contrib non-free" >> /etc/apt/sources.list
#    fi
    if [ $this_astra = 1 ]; then
        apt update
        apt install ca-certificates acl -y
    else
        apt update
        apt install ca-certificates acl rsyslog -y
    fi
elif [ $distr = rpm ]; then
    dnf install ca-certificates acl rsyslog -y
fi

# settings pgsql
sudo -u postgres psql <<EOF
CREATE DATABASE ${db_postfix} ENCODING 'UTF-8';
CREATE USER postfix WITH PASSWORD '${secret_postfix}';
GRANT ALL PRIVILEGES ON DATABASE ${db_postfix} TO postfix;
\c ${db_postfix};
create table virtual_domains (id serial primary key, name varchar(50) not null);
create table virtual_users (id serial primary key, domain_id int not null, password varchar(106) not null, email varchar(120) not null, unique (email), foreign key (domain_id) references virtual_domains(id) on delete cascade);
create table virtual_aliases (id serial primary key, domain_id int not null, source varchar(100) not null, destination varchar(100) not null, foreign key (domain_id) references virtual_domains(id) on delete cascade);
GRANT ALL PRIVILEGES ON TABLE virtual_users TO postfix;
GRANT ALL PRIVILEGES ON TABLE virtual_domains TO postfix;
GRANT ALL PRIVILEGES ON TABLE virtual_users_id_seq TO postfix;
GRANT ALL PRIVILEGES ON TABLE virtual_aliases TO postfix;
GRANT ALL PRIVILEGES ON TABLE virtual_aliases_id_seq TO postfix;
insert into virtual_domains (name) values ('${CDDISK_DOMAIN}');
\q
EOF

# install postfix
if [ $distr = deb ]; then
    debconf-set-selections <<< "postfix postfix/mailname string $hostname_var"
    debconf-set-selections <<< "postfix postfix/main_mailer_type string 'Internet Site'"
    if [ -f /var/tmp/r7offline ]; then
	apt-get install -y --assume-yes ./../iso/archives/postfix*.deb ./../iso/archives/postfix-pgsql*.deb
    else
	apt-get install --assume-yes postfix postfix-pgsql -y
    fi
elif [ $distr = rpm ]; then
    if [ -f /var/tmp/r7offline ]; then
	dnf install -y ./../dnfcache/postfix*.rpm ./../dnfcache/postfix-pgsql*.rpm
    else
	dnf install  postfix postfix-pgsql -y
    fi
fi

systemctl stop postfix

# install dovecot
if [ $distr = deb ]; then
    if [ -f /var/tmp/r7offline ]; then
	apt-get install -y ./../iso/archives/dovecot-core*.deb ./../iso/archives/dovecot-imapd*.deb ./../iso/archives/dovecot-pop3d*.deb ./../iso/archives/dovecot-sieve*.deb ./../iso/archives/dovecot-managesieved*.deb ./../iso/archives/dovecot-lmtpd*.deb ./../iso/archives/dovecot-pgsql*.deb
    else
	apt install dovecot-imapd dovecot-pop3d dovecot-sieve dovecot-managesieved dovecot-lmtpd dovecot-pgsql -y
    fi
elif [ $distr = rpm ]; then
    if [ -f /var/tmp/r7offline ]; then
	dnf install -y ./../dnfcache/dovecot*.rpm ./../dnfcache/dovecot-pgsql*.rpm ./../dnfcache/dovecot-pigeonhole*.rpm
    else
	dnf install dovecot dovecot-pgsql dovecot-pigeonhole -y
    fi
fi

systemctl stop dovecot

# create dir for mail
groupadd -g 1100 vmail
mkdir $dir_mail
mkdir $dir_mail/shared-folders
useradd -d /mail -g 1100 -u 1100 vmail
usermod -a -G dovecot vmail
chown vmail:vmail /mail

# create dir for logs dovecot
mkdir $dir_log_dovecot
touch /var/log/dovecot/{main.log,info.log,debug.log,lda-errors.log,lda-deliver.log,lmtp.log}
chown -R vmail:dovecot $dir_log_dovecot

# install spamassassin
if [ $spamassassin = install_spamassassin ]; then
    if [ $distr = deb ]; then
	if [ -f /var/tmp/r7offline ]; then
	    apt-get install -y ./../iso/archives/spamassassin*.deb ./../iso/archives/spamc*.deb
	else
	    apt install spamassassin spamc -y
	fi
    elif [ $distr = rpm ]; then
        if [ $redhat_ver = centos ]; then
            dnf install spamassassin spamass-milter -y
        elif [ $redhat_ver = redos ]; then
	    if [ -f /var/tmp/r7offline ]; then
		dnf install -y ./../dnfcache/spamassassin*.rpm
	    else
		dnf install spamassassin -y
	    fi
            dnf install ./mailserver/spamass-milter-*.rpm -y
            systemctl enable spamassassin.service
            groupadd spamd
            useradd -g spamd -s /bin/false -d /var/log/spamassassin spamd
            mkdir /var/log/spamassassin
            chown spamd:spamd /var/log/spamassassin
            service spamassassin start
            service spamassassin.service restart
            sudo systemctl enable --now spamass-milter
        fi
    fi
fi

# settings postfix for redos
if [ $redhat_ver = redos ]; then
    mkdir $dir_etc_postfix
    cp /etc/host.conf $dir_etc_postfix/
    cp /etc/resolv.conf $dir_etc_postfix/
    cp /etc/services $dir_etc_postfix/
    chmod 1777 /etc/resolv.conf
    chmod 1777 -R /var/spool/postfix/etc
fi

## copy config files
# postfix
mkdir $dir_postfix/pgsql
#mkdir $dir_postfix/certs

if [ $distr = "deb" ]; then
    cp $dir_install/mailserver-ubuntu22-config/config/main_pgsql.cf $dir_postfix/main.cf
    cp $dir_install/mailserver-ubuntu22-config/config/master.cf $dir_postfix/
    cp $dir_install/mailserver-ubuntu22-config/config/tls_policy_maps $dir_postfix/
    cp -pr $dir_install/mailserver-ubuntu22-config/config/pgsql/* $dir_postfix/pgsql/
    #cp -pr $dir_install/mailserver-ubuntu22-config/config/certs/* /etc/ssl/

    # dovecot
    cp $dir_install/mailserver-ubuntu22-config/config/dovecot_pgsql.conf $dir_dovecot/dovecot.conf
    cp $dir_install/mailserver-ubuntu22-config/config/dovecot-pgsql.conf $dir_dovecot/

    # mail
    chown -R vmail:vmail $dir_mail/

    # spamassassin
    if [ $spamassassin = install_spamassassin ]; then
        cp $dir_install/mailserver-ubuntu22-config/config/spamassassin/local.cf $dir_spam/
        cp $dir_install/mailserver-ubuntu22-config/config/spamassassin/spamassassin $dir_def/
        cp $dir_install/mailserver-ubuntu22-config/config/spamassassin/master.cf $dir_postfix/
    fi
    elif [ $distr = "rpm" ]; then
    cp $dir_install/mailserver-redos73-config/config/main_pgsql.cf $dir_postfix/main.cf
    cp $dir_install/mailserver-redos73-config/config/master.cf $dir_postfix/
    cp $dir_install/mailserver-redos73-config/config/tls_policy_maps $dir_postfix/
    cp -pr $dir_install/mailserver-redos73-config/config/pgsql/* $dir_postfix/pgsql/
    #cp -pr $dir_install/mailserver-redos73-config/config/certs/* /etc/ssl/

    # dovecot
    cp $dir_install/mailserver-redos73-config/config/dovecot_pgsql.conf $dir_dovecot/dovecot.conf
    cp $dir_install/mailserver-redos73-config/config/dovecot-pgsql.conf $dir_dovecot/

    # mail chown 
    chown -R vmail:vmail $dir_mail/

    # spamassassin
    if [ $spamassassin = install_spamassassin ]; then
        cp $dir_install/mailserver-redos73-config/config/spamassassin/local.cf $dir_spam/
        cp $dir_install/mailserver-redos73-config/config/spamassassin/spamassassin $dir_def/
        cp $dir_install/mailserver-redos73-config/config/spamassassin/master.cf $dir_postfix/
    fi
else
    echo "Дистрибутив с пакетным менеджером $distr не поддерживается"
fi

# install opendkim
if [ "$openDKIMinstall" = "true" ]; then
    if [ "$distr" = "deb" ]; then
	if [ -f /var/tmp/r7offline ]; then
	    apt-get install -y ./../iso/archives/opendkim*.deb ./../iso/archives/opendkim-tools*.deb
	else
	    apt install opendkim opendkim-tools -y
	fi
    elif [ "$distr" = "rpm" ]; then
	if [ -f /var/tmp/r7offline ]; then
	    dnf install -y ./../dnfcache/opendkim*.rpm ./../dnfcache/opendkim-tools*.rpm
	else
	    dnf install opendkim opendkim-tools -y
	fi
    else
    echo "Дистрибутив с пакетным менеджером $distr не поддерживается"
    fi
    
    systemctl start opendkim
    systemctl enable opendkim

    mkdir -p /etc/opendkim/keys/$domain_name
    opendkim-genkey -b 1024 --directory /etc/opendkim/keys/$domain_name/ --domain $domain_name --selector dkim
    chown -R opendkim:opendkim /etc/opendkim/keys/$domain_name

    echo "*.$domain_name" > /etc/opendkim/TrustedHosts
    echo "127.0.0.1" >> /etc/opendkim/TrustedHosts
    echo "localhost" >> /etc/opendkim/TrustedHosts
    echo "dkim._domainkey.$domain_name $domain_name:dkim:/etc/opendkim/keys/$domain_name/dkim.private" > /etc/opendkim/KeyTable
    echo "*@$domain_name dkim._domainkey.$domain_name" > /etc/opendkim/SigningTable
    
    if [ "$distr" = "deb" ]; then
	cp $dir_install/mailserver-ubuntu22-config/config/opendkim /etc/default/opendkim
	cp $dir_install/mailserver-ubuntu22-config/config/opendkim.conf /etc/opendkim.conf
    elif [ "$distr" = "rpm" ]; then
	cp $dir_install/mailserver-redos73-config/config/opendkim /etc/default/opendkim
	cp $dir_install/mailserver-redos73-config/config/opendkim.conf /etc/opendkim.conf
    fi

    sed -i -e '$a\milter_default_action = accept' -e '$a\milter_protocol = 6' -e '$a\smtpd_milters = inet:localhost:8891' -e '$a\non_smtpd_milters = inet:localhost:8891' /etc/postfix/main.cf

    systemctl restart opendkim

    echo "Пожалуйста, добавьте следующую запись TXT в DNS:"
    echo "Наименование: dkim._domainkey.$domain_name"
    echo "Значение (TXT запись):"
    cat /etc/opendkim/keys/$domain_name/dkim.txt
fi

# restart service mariadb postfix dovecot

sed -i "s/myhostname = mx1.your-domain.ru/myhostname = $hostname_var/" /etc/postfix/main.cf
sed -i "s/mydomain = your-domain.ru/mydomain = $domain_name/" /etc/postfix/main.cf
sed -i "s/auth_default_realm = your-domain.ru/auth_default_realm = $domain_name/" /etc/dovecot/dovecot.conf
sed -i "s/password = password/password = $secret_postfix/" /etc/postfix/pgsql/virtual_alias_maps.cf
sed -i "s/password = password/password = $secret_postfix/" /etc/postfix/pgsql/virtual_mailbox_domains.cf
sed -i "s/password = password/password = $secret_postfix/" /etc/postfix/pgsql/virtual_mailbox_maps.cf
sed -i "s/connect = host=127.0.0.1 dbname=postfix user=postfix password=password/connect = host=127.0.0.1 dbname=postfix user=postfix password=$secret_postfix/" /etc/dovecot/dovecot-pgsql.conf

sed -i 's#smtpd_tls_cert_file = /etc/ssl/mail_cert.pem#smtpd_tls_cert_file = /etc/nginx/ssl/'$domain_name'.crt#' /etc/postfix/main.cf
sed -i 's#smtpd_tls_key_file = /etc/ssl/mail_key.pem#smtpd_tls_key_file = /etc/nginx/ssl/'$domain_name'.key#' /etc/postfix/main.cf
sed -i 's#ssl_cert = </etc/ssl/mail_cert.pem#ssl_cert = </etc/nginx/ssl/'$domain_name'.crt#' /etc/dovecot/dovecot.conf
sed -i 's#ssl_key = </etc/ssl/mail_key.pem#ssl_key = </etc/nginx/ssl/'$domain_name'.key#' /etc/dovecot/dovecot.conf

# Дополнительные действия для интеграции с Р7-Диск
username="mail_cddisk"
password=$(< /dev/urandom tr -dc A-Za-z0-9 | head -c15) 
if [ "$distr" = "deb" ]; then
    adduser --disabled-password --gecos "" $username 
elif [ "$distr" = "rpm" ]; then
    adduser $username 
fi
echo "$username:$password" | chpasswd 
sudoers_file="/etc/sudoers.d/cddisk"
sudo sh -c "echo 'mail_cddisk ALL=(ALL) NOPASSWD: /usr/bin/doveadm' > $sudoers_file"
chmod 440 $sudoers_file 
chown root:mail_cddisk /etc/dovecot/dovecot-pgsql.conf
mkdir /script
scripts_url="mailserver/operations_mailserver_db-pgsql.tar.gz"
cp $scripts_url /script
tar -xf /script/operations_mailserver_db-pgsql.tar.gz -C /
mv /operations_mailserver_db-pgsql-mailserver/mailserver/* /script
rm -r /operations_mailserver_db-pgsql-mailserver/
chmod +x -R /script
chown -R mail_cddisk:mail_cddisk /script
rm /script/operations_mailserver_db-pgsql.tar.gz
su - mail_cddisk -c "ssh-keygen -t ed25519 -f /home/mail_cddisk/.ssh/id_ed25519 -q -N ''"
private_key=$(base64 -w 0 /home/mail_cddisk/.ssh/id_ed25519)
public_key=$(< /home/mail_cddisk/.ssh/id_ed25519.pub)
echo "$public_key" >> /home/mail_cddisk/.ssh/authorized_keys
systemctl restart sshd

if [[ $this_astra = 1 ]]; then
    IMAPPORT=993
    SMTPPORT=465
    IMAPCONNECTIONTYPE=2
    POP3CONNECTIONTYPE=0
    SMTPCONNECTIONTYPE=2
else
    IMAPPORT=993
    SMTPPORT=465
    IMAPCONNECTIONTYPE=2
    POP3CONNECTIONTYPE=0
    SMTPCONNECTIONTYPE=2
fi

IMAPSERVER="'$hostname_var'"
POP3SERVER="'$hostname_var'"
SMTPSERVER="'$hostname_var'"
POP3PORT=995
USESSL=True
CUSTOMERID=0
NAME="'Почтовый сервер Р7-Офис'"
DOMAINS="'$domain_name'"
SSH_SERVER="$hostname_var"
SSH_PORT=22
SSH_USER="mail_cddisk"
SSH_PRIVATE_KEY_BASE64="$private_key"
JSON="'{\"Ssh\":{\"Server\":\"$SSH_SERVER\",\"User\":\"$SSH_USER\",\"Password\":null,\"Port\":$SSH_PORT,\"PrivateKeyBase64\":\"$SSH_PRIVATE_KEY_BASE64\",\"PublicKeyBase64\":null}}'"

echo "insert into public.\"EmailServers\"(\"ImapServer\",\"ImapPort\",\"SmtpServer\",\"SmtpPort\",\"PopServer\",\"PopPort\",\"UseSsl\",\"CustomerId\",\"SmtpConnectionType\",\"PopConnectionType\",\"ImapConnectionType\",\"Json\",\"Name\",\"Domains\") VALUES($IMAPSERVER,$IMAPPORT,$SMTPSERVER,$SMTPPORT,$POP3SERVER,$POP3PORT,$USESSL,$CUSTOMERID,$SMTPCONNECTIONTYPE,$POP3CONNECTIONTYPE,$IMAPCONNECTIONTYPE,$JSON,$NAME,$DOMAINS);"
sudo -u $DB_USER psql -h $DB_HOST -d $DB_NAME <<EOF
\x
insert into public."EmailServers"("ImapServer", "ImapPort", "SmtpServer","SmtpPort","PopServer","PopPort","UseSsl","CustomerId","SmtpConnectionType","PopConnectionType","ImapConnectionType","Json","Name","Domains") VALUES($IMAPSERVER,$IMAPPORT,$SMTPSERVER,$SMTPPORT,$POP3SERVER,$POP3PORT,$USESSL,$CUSTOMERID,$SMTPCONNECTIONTYPE,$POP3CONNECTIONTYPE,$IMAPCONNECTIONTYPE,$JSON,$NAME,$DOMAINS);
EOF

rm /etc/postfix/makedefs.out; ln /usr/share/postfix/makedefs.out /etc/postfix/makedefs.out
chmod 640 -R /etc/postfix/pgsql/
sudo postfix check
systemctl restart postfix
systemctl enable postfix
postmap /etc/postfix/tls_policy_maps

systemctl restart dovecot
systemctl enable dovecot

# restart spamassassin
if [ $spamassassin = install_spamassassin ]; then
    if [ $redhat_ver = redos ]; then
        service spamassassin.service restart
        systemctl enable --now spamass-milter
    elif [ $redhat_ver != redos ]; then
        systemctl restart spamassassin.service
        systemctl enable spamassassin.service
    fi
fi

}

fn_read_params_mariadb()
{
    hostname_in=$(whiptail --inputbox "Введите название mx записи:" 10 60 "mx" 3>&1 1>&2 2>&3)
    hostname_status=$?
    if [ $hostname_status -eq 0 ]; then
	hostname="$hostname_in.$CDDISK_DOMAIN"
	echo "hostname: $hostname"
	hostnamectl set-hostname "$hostname"
	systemctl restart systemd-hostnamed
	ip_mail=$(whiptail --inputbox "Введите IP адрес почтового сервера:" 10 60 3>&1 1>&2 2>&3)
	ip_mail_status=$?
	if [ $ip_mail_status -eq 0 ]; then
	    echo -e "\n$ip_mail $hostname_in $hostname" >> /etc/hosts
	    secret_mysql=$(whiptail --passwordbox "Введите пароль для root в почтовой БД MariaDB:" 10 60 3>&1 1>&2 2>&3)
	    secret_mysql_status=$?
	    if [ $secret_mysql_status -eq 0 ]; then
		secret_postfix=$(whiptail --passwordbox "Введите пароль для postfix в почтовой БД MariaDB:" 10 60 3>&1 1>&2 2>&3)
		secret_postfix_status=$?
		if [ $secret_postfix_status -eq 0 ]; then
		    spamassassin_choice=$(whiptail --title "Установка SpamAssassin" --menu "Выберите опцию установки SpamAssassin:" 15 60 4 \
		    "1" "Установить SpamAssassin" \
			"2" "Не устанавливать SpamAssassin" 3>&1 1>&2 2>&3)
		    spamassassin_status=$?
		    if [ $spamassassin_status -eq 0 ]; then
			if [ "$spamassassin_choice" == "1" ]; then
			    spamassassin="install_spamassassin"
			else
			    spamassassin="not_install_spamassassin"
			fi
		    else
			whiptail --msgbox "Выбор установки SpamAssassin отменен. Установка прервана." 10 60
		    fi
		    if whiptail --yesno "Установить OpenDKIM?" 10 60; then
			openDKIMinstall="true"
		    fi
		else
		    echo "Ввод пароля для postfix отменен. Установка прервана"
		    exit 1
		fi
	    else
		echo "Ввод пароля для root в БД MariaDB отменен. Установка прервана"
		exit 1
	    fi
	else
	    echo "Ввод IP адреса почтового сервера отменен. Установка прервана"
	    exit 1
	fi
    else
	echo "Ввод hostname отменен. Установка прервана"
	exit 1
    fi
}

fn_install_mail_mariadb()
{
data_today=$(date '+%d_%M_%Y')
mysql_root="mysql -uroot -p${secret_mysql}"
mysql="mysql -uroot"
hostname_var=$(cat /etc/hostname)
domain_name=$(echo "$hostname_var" | cut -d'.' -f2-)
db_postfix=postfix
redhat_ver=blank
this_astra=0
distr=blank

# set config dir
dir_mail=/mail
dir_postfix=/etc/postfix
dir_dovecot=/etc/dovecot
dir_www=/var/www/html
dir_spam=/etc/spamassassin
dir_log_dovecot=/var/log/dovecot
dir_etc_postfix=/var/spool/postfix/etc
dir_def=/etc/default
dir_install=./

# OS version detection
if dpkg --help &> /dev/null; then
    distr=deb
    if [ -e /etc/astra_version ]; then
        this_astra=1
    fi
elif rpm --help &> /dev/null; then
    if apt-get --help &> /dev/null; then
        distr=alt
    else
        distr=rpm
        if [[ "$(cat /etc/redhat-release)" == *"Stream"* ]]; then
            redhat_ver=centos
        elif [[ "$(cat /etc/redhat-release)" == *"MUROM"* ]]; then
            redhat_ver=redos
        fi
    fi
fi

# install bzip2
if [ $distr = deb ]; then
    if aptitude search '~i bzip2' &> /dev/null; then
        echo ""
    else
        apt update && apt install bzip2 -y
    fi
elif [ $distr = rpm ]; then
    if rpm -q bzip &> /dev/null; then
        echo ""
    else
        dnf install bzip2 -y
    fi
elif [ $distr = alt ]; then
    if rpm -q bzip &> /dev/null; then
        echo ""
    else
        apt-get install bzip2 -y
    fi
fi

# install tar
if [ $distr = deb ]; then
    if aptitude search '~i tar' &> /dev/null; then
        echo ""
    else
        apt update && apt install tar -y
    fi
elif [ $distr = rpm ]; then
    if rpm -q tar &> /dev/null; then
        echo ""
    else
        dnf install tar -y
    fi
elif [ $distr = alt ]; then
    if rpm -q tar &> /dev/null; then
        echo ""
    else
        apt-get install tar -y
    fi
fi

# unzipping the archive
if [ $distr = deb ]; then
    tar xvjf mailserver/deb-config.tar.bz2 -C $dir_install
elif [ $distr = rpm ]; then
    tar xvjf rpm-config.tar.bz2 -C $dir_install
fi

# install mariadb, nginx
if [ $distr = deb ]; then
#    if [ $this_astra = 1 ]; then
#        echo "deb https://dl.astralinux.ru/astra/stable/1.7_x86-64/repository-extended/ 1.7_x86-64 main contrib non-free" >> /etc/apt/sources.list
#    fi
    if [ $this_astra = 1 ]; then
        apt update
	apt install ca-certificates acl -y
	if [ -f /var/tmp/r7offline ]; then
	    apt-get install -y ./../iso/archives/mariadb-server*.deb ./../iso/archives/mariadb-common*.deb
	else
	    apt-get install -y mariadb-server
	fi
    else
        apt update
        apt install ca-certificates acl rsyslog -y
	if [ -f /var/tmp/r7offline ]; then
	    apt-get install -y ./../iso/archives/mariadb-server*.rpm ./../iso/archives/mariadb-common*.rpm
	else
	    apt install -y mariadb-server
	fi
    fi
    systemctl enable --now mariadb
elif [ $distr = rpm ]; then
    dnf install ca-certificates mariadb-server mariadb acl rsyslog -y
    if [ -f /var/tmp/r7offline ]; then
	dnf install -y ./../dnfcache/mariadb-server*.rpm ./../dnfcache/mariadb*.rpm
    else
	dnf install -y mariadb-server mariadb
    fi
    systemctl enable --now mariadb
fi

# settings mysql
$mysql -e "alter user root@localhost identified by '${secret_mysql}';"
$mysql_root -e "create database ${db_postfix};"
$mysql_root -e "create user postfix@localhost identified by '${secret_postfix}';"
$mysql_root -e "grant all privileges on *.* to postfix@localhost;"
$mysql_root -e "create table postfix.virtual_domains (id int not null auto_increment, name varchar(50) not null, primary key (id)) engine=innodb default charset=utf8;"
$mysql_root -e "create table postfix.virtual_users (id int not null auto_increment, domain_id int not null, password varchar(106) not null, email varchar(120) not null, primary key (id), unique key email (email), foreign key (domain_id) references virtual_domains(id) on delete cascade) engine=innodb default charset=utf8;"
$mysql_root -e "create table postfix.virtual_aliases (id int not null auto_increment, domain_id int not null, source varchar(100) not null, destination varchar(100) not null, primary key (id), foreign key (domain_id) references virtual_domains(id) on delete cascade) engine=innodb default charset=utf8;"
$mysql_root -e "insert into postfix.virtual_domains (id, name) values ('1', '$domain_name');"
$mysql_root -e "flush privileges;"

systemctl stop mariadb

# install postfix
if [ $distr = deb ]; then
    debconf-set-selections <<< "postfix postfix/mailname string $hostname_var"
    debconf-set-selections <<< "postfix postfix/main_mailer_type string 'Internet Site'"
    if [ -f /var/tmp/r7offline ]; then
	apt-get install -y ./../iso/archives/postfix*.deb ./../iso/archives/postfix-mysql*.deb
    else
	apt install --assume-yes  postfix postfix-mysql -y
    fi
elif [ $distr = rpm ]; then
    if [ -f /var/tmp/r7offline ]; then
	dnf install -y ./../dnfcache/postfix*.rpm ./../dnfcache/postfix-mysql*.rpm
    else
	dnf install  postfix postfix-mysql -y
    fi
fi

systemctl stop postfix

# install dovecot
if [ $distr = deb ]; then
    if [ -f /var/tmp/r7offline ]; then
	apt-get install -y ./../iso/archives/dovecot-core*.deb ./../iso/archives/dovecot-imapd*.deb ./../iso/archives/dovecot-pop3d*.deb ./../iso/archives/dovecot-sieve*.deb ./../iso/archives/dovecot-managesieved*.deb ./../iso/archives/dovecot-lmtpd*.deb ./../iso/archives/dovecot-mysql*.deb
    else
	apt install dovecot-imapd dovecot-pop3d dovecot-sieve dovecot-managesieved dovecot-lmtpd dovecot-mysql -y
    fi
elif [ $distr = rpm ]; then
    if [ -f /var/tmp/r7offline ]; then
	dnf install -y ./../dnfcache/dovecot*.rpm ./../dnfcache/dovecot-mysql*.rpm ./../dnfcache/dovecot-pigeonhole*.rpm
    else
	dnf install dovecot dovecot-mysql dovecot-pigeonhole -y
    fi
fi

systemctl stop dovecot

# create dir for mail
groupadd -g 1100 vmail
mkdir $dir_mail
mkdir $dir_mail/shared-folders
useradd -d /mail -g 1100 -u 1100 vmail
usermod -a -G dovecot vmail
chown vmail:vmail /mail

# create dir for logs dovecot
mkdir $dir_log_dovecot
touch /var/log/dovecot/{main.log,info.log,debug.log,lda-errors.log,lda-deliver.log,lmtp.log}
chown -R vmail:dovecot $dir_log_dovecot

# install spamassassin
if [ $spamassassin = install_spamassassin ]; then
    if [ $distr = deb ]; then
	if [ -f /var/tmp/r7offline ]; then
	    apt-get install -y ./../iso/archives/spamassassin*.deb ./../iso/archives/spamc*.deb
	else
	    apt install spamassassin spamc -y
	fi
    elif [ $distr = rpm ]; then
        if [ $redhat_ver = centos ]; then
            dnf install spamassassin spamass-milter -y
        elif [ $redhat_ver = redos ]; then
	    if [ -f /var/tmp/r7offline ]; then
		dnf install -y ./../dnfcache/spamassassin*.rpm
	    else
		dnf install spamassassin -y
	    fi
            dnf install ./mailserver/spamass-milter-*.rpm -y
            systemctl enable spamassassin.service
            groupadd spamd
            useradd -g spamd -s /bin/false -d /var/log/spamassassin spamd
            mkdir /var/log/spamassassin
            chown spamd:spamd /var/log/spamassassin
            service spamassassin start
            service spamassassin.service restart
            sudo systemctl enable --now spamass-milter
        fi
    fi
fi

# settings postfix for redos
if [ $redhat_ver = redos ]; then
    mkdir $dir_etc_postfix
    cp /etc/host.conf $dir_etc_postfix/
    cp /etc/resolv.conf $dir_etc_postfix/
    cp /etc/services $dir_etc_postfix/
    chmod 1777 /etc/resolv.conf
    chmod 1777 -R /var/spool/postfix/etc
fi

## copy config files
# postfix
mkdir $dir_postfix/mysql
#mkdir $dir_postfix/certs

if [ $distr = "deb" ]; then
    cp $dir_install/mailserver-ubuntu22-config/config/main.cf $dir_postfix/
    cp $dir_install/mailserver-ubuntu22-config/config/master.cf $dir_postfix/
    cp $dir_install/mailserver-ubuntu22-config/config/tls_policy_maps $dir_postfix/
    cp -pr $dir_install/mailserver-ubuntu22-config/config/mysql/* $dir_postfix/mysql/
    #cp -pr $dir_install/mailserver-ubuntu22-config/config/certs/* /etc/ssl/

    # dovecot
    cp $dir_install/mailserver-ubuntu22-config/config/dovecot.conf $dir_dovecot/
    cp $dir_install/mailserver-ubuntu22-config/config/dovecot-mysql.conf $dir_dovecot/

    # mail
    chown -R vmail:vmail $dir_mail/

    # spamassassin
    if [ $spamassassin = install_spamassassin ]; then
        cp $dir_install/mailserver-ubuntu22-config/config/spamassassin/local.cf $dir_spam/
        cp $dir_install/mailserver-ubuntu22-config/config/spamassassin/spamassassin $dir_def/
        cp $dir_install/mailserver-ubuntu22-config/config/spamassassin/master.cf $dir_postfix/
    fi
    elif [ $distr = "rpm" ]; then
    cp $dir_install/mailserver-redos73-config/config/main.cf $dir_postfix/
    cp $dir_install/mailserver-redos73-config/config/master.cf $dir_postfix/
    cp $dir_install/mailserver-redos73-config/config/tls_policy_maps $dir_postfix/
    cp -pr $dir_install/mailserver-redos73-config/config/mysql/* $dir_postfix/mysql/
    #cp -pr $dir_install/mailserver-redos73-config/config/certs/* /etc/ssl/

    # dovecot
    cp $dir_install/mailserver-redos73-config/config/dovecot.conf $dir_dovecot/
    cp $dir_install/mailserver-redos73-config/config/dovecot-mysql.conf $dir_dovecot/

    # mail chown 
    chown -R vmail:vmail $dir_mail/

    # spamassassin
    if [ $spamassassin = install_spamassassin ]; then
        cp $dir_install/mailserver-redos73-config/config/spamassassin/local.cf $dir_spam/
        cp $dir_install/mailserver-redos73-config/config/spamassassin/spamassassin $dir_def/
        cp $dir_install/mailserver-redos73-config/config/spamassassin/master.cf $dir_postfix/
    fi
else
    echo "Дистрибутив с пакетным менеджером $distr не поддерживается"
fi

# install opendkim
if [ "$openDKIMinstall" = "true" ]; then
    if [ "$distr" = "deb" ]; then
	if [ -f /var/tmp/r7offline ]; then
	    apt-get install -y ./../iso/archives/opendkim*.deb ./../iso/archives/opendkim-tools*.deb
	else
	    apt install opendkim opendkim-tools -y
	fi
    elif [ "$distr" = "rpm" ]; then
	if [ -f /var/tmp/r7offline ]; then
	    dnf install -y ./../dnfcache/opendkim*.rpm ./../dnfcache/opendkim-tools*.rpm
	else
	    dnf install opendkim opendkim-tools -y
	fi
    else
	echo "Дистрибутив с пакетным менеджером $distr не поддерживается"
    fi
    
    systemctl start opendkim
    systemctl enable opendkim

    mkdir -p /etc/opendkim/keys/$domain_name
    opendkim-genkey -b 1024 --directory /etc/opendkim/keys/$domain_name/ --domain $domain_name --selector dkim
    chown -R opendkim:opendkim /etc/opendkim/keys/$domain_name

    echo "*.$domain_name" > /etc/opendkim/TrustedHosts
    echo "127.0.0.1" >> /etc/opendkim/TrustedHosts
    echo "localhost" >> /etc/opendkim/TrustedHosts
    echo "dkim._domainkey.$domain_name $domain_name:dkim:/etc/opendkim/keys/$domain_name/dkim.private" > /etc/opendkim/KeyTable
    echo "*@$domain_name dkim._domainkey.$domain_name" > /etc/opendkim/SigningTable
    
    if [ "$distr" = "deb" ]; then
    cp $dir_install/mailserver-ubuntu22-config/config/opendkim /etc/default/opendkim
    cp $dir_install/mailserver-ubuntu22-config/config/opendkim.conf /etc/opendkim.conf
    elif [ "$distr" = "rpm" ]; then
    cp $dir_install/mailserver-redos73-config/config/opendkim /etc/default/opendkim
    cp $dir_install/mailserver-redos73-config/config/opendkim.conf /etc/opendkim.conf
    fi

    sed -i -e '$a\milter_default_action = accept' -e '$a\milter_protocol = 6' -e '$a\smtpd_milters = inet:localhost:8891' -e '$a\non_smtpd_milters = inet:localhost:8891' /etc/postfix/main.cf

    systemctl restart opendkim

    echo "Пожалуйста, добавьте следующую запись TXT в DNS:"
    echo "Наименование: dkim._domainkey.$domain_name"
    echo "Значение (TXT запись):"
    cat /etc/opendkim/keys/$domain_name/dkim.txt
fi

# restart service mariadb postfix dovecot
systemctl restart mariadb
systemctl enable mariadb

sed -i "s/myhostname = mx1.your-domain.ru/myhostname = $hostname_var/" /etc/postfix/main.cf
sed -i "s/mydomain = your-domain.ru/mydomain = $domain_name/" /etc/postfix/main.cf
sed -i "s/auth_default_realm = your-domain.ru/auth_default_realm = $domain_name/" /etc/dovecot/dovecot.conf
sed -i "s/password = password/password = $secret_postfix/" /etc/postfix/mysql/virtual_alias_maps.cf
sed -i "s/password = password/password = $secret_postfix/" /etc/postfix/mysql/virtual_mailbox_domains.cf
sed -i "s/password = password/password = $secret_postfix/" /etc/postfix/mysql/virtual_mailbox_maps.cf
sed -i "s/connect = host=127.0.0.1 dbname=postfix user=postfix password=password/connect = host=127.0.0.1 dbname=postfix user=postfix password=$secret_postfix/" /etc/dovecot/dovecot-mysql.conf

sed -i 's#smtpd_tls_cert_file = /etc/ssl/mail_cert.pem#smtpd_tls_cert_file = /etc/nginx/ssl/'$domain_name'.crt#' /etc/postfix/main.cf
sed -i 's#smtpd_tls_key_file = /etc/ssl/mail_key.pem#smtpd_tls_key_file = /etc/nginx/ssl/'$domain_name'.key#' /etc/postfix/main.cf
sed -i 's#ssl_cert = </etc/ssl/mail_cert.pem#ssl_cert = </etc/nginx/ssl/'$domain_name'.crt#' /etc/dovecot/dovecot.conf
sed -i 's#ssl_key = </etc/ssl/mail_key.pem#ssl_key = </etc/nginx/ssl/'$domain_name'.key#' /etc/dovecot/dovecot.conf

# Дополнительные действия для интеграции с Р7-Диск
username="mail_cddisk"
password=$(< /dev/urandom tr -dc A-Za-z0-9 | head -c15) 
if [ "$distr" = "deb" ]; then
    adduser --disabled-password --gecos "" $username 
elif [ "$distr" = "rpm" ]; then
    adduser $username 
fi
echo "$username:$password" | chpasswd 
sudoers_file="/etc/sudoers.d/cddisk"
sudo sh -c "echo 'mail_cddisk ALL=(ALL) NOPASSWD: /usr/bin/doveadm' > $sudoers_file"
chmod 440 $sudoers_file 
chown root:mail_cddisk /etc/dovecot/dovecot-mysql.conf
mkdir /script
scripts_url="mailserver/scripts.tar.gz"
cp $scripts_url /script
tar -xf /script/scripts.tar.gz -C /
chmod +x -R /script
chown -R mail_cddisk:mail_cddisk /script
su - mail_cddisk -c "ssh-keygen -t ed25519 -f /home/mail_cddisk/.ssh/id_ed25519 -q -N ''"
private_key=$(base64 -w 0 /home/mail_cddisk/.ssh/id_ed25519)
public_key=$(< /home/mail_cddisk/.ssh/id_ed25519.pub)
echo "$public_key" >> /home/mail_cddisk/.ssh/authorized_keys
systemctl restart sshd

if [[ $this_astra = 1 ]]; then
    IMAPPORT=993
    SMTPPORT=465
    IMAPCONNECTIONTYPE=2
    POP3CONNECTIONTYPE=0
    SMTPCONNECTIONTYPE=2
else
    IMAPPORT=993
    SMTPPORT=465
    IMAPCONNECTIONTYPE=2
    POP3CONNECTIONTYPE=0
    SMTPCONNECTIONTYPE=2
fi

IMAPSERVER="'$hostname_var'"
POP3SERVER="'$hostname_var'"
SMTPSERVER="'$hostname_var'"
POP3PORT=995
USESSL=True
CUSTOMERID=0
NAME="'Почтовый сервер Р7-Офис'"
DOMAINS="'$domain_name'"
SSH_SERVER="$hostname_var"
SSH_PORT=22
SSH_USER="mail_cddisk"
SSH_PRIVATE_KEY_BASE64="$private_key"
JSON="'{\"Ssh\":{\"Server\":\"$SSH_SERVER\",\"User\":\"$SSH_USER\",\"Password\":null,\"Port\":$SSH_PORT,\"PrivateKeyBase64\":\"$SSH_PRIVATE_KEY_BASE64\",\"PublicKeyBase64\":null}}'"

echo "insert into public.\"EmailServers\"(\"ImapServer\",\"ImapPort\",\"SmtpServer\",\"SmtpPort\",\"PopServer\",\"PopPort\",\"UseSsl\",\"CustomerId\",\"SmtpConnectionType\",\"PopConnectionType\",\"ImapConnectionType\",\"Json\",\"Name\",\"Domains\") VALUES($IMAPSERVER,$IMAPPORT,$SMTPSERVER,$SMTPPORT,$POP3SERVER,$POP3PORT,$USESSL,$CUSTOMERID,$SMTPCONNECTIONTYPE,$POP3CONNECTIONTYPE,$IMAPCONNECTIONTYPE,$JSON,$NAME,$DOMAINS);"
sudo -u $DB_USER psql -h $DB_HOST -d $DB_NAME <<EOF
\x
insert into public."EmailServers"("ImapServer", "ImapPort", "SmtpServer","SmtpPort","PopServer","PopPort","UseSsl","CustomerId","SmtpConnectionType","PopConnectionType","ImapConnectionType","Json","Name","Domains") VALUES($IMAPSERVER,$IMAPPORT,$SMTPSERVER,$SMTPPORT,$POP3SERVER,$POP3PORT,$USESSL,$CUSTOMERID,$SMTPCONNECTIONTYPE,$POP3CONNECTIONTYPE,$IMAPCONNECTIONTYPE,$JSON,$NAME,$DOMAINS);
EOF

rm /etc/postfix/makedefs.out; ln /usr/share/postfix/makedefs.out /etc/postfix/makedefs.out
chmod 640 -R /etc/postfix/mysql/
sudo postfix check
systemctl restart postfix
systemctl enable postfix
postmap /etc/postfix/tls_policy_maps

systemctl restart dovecot
systemctl enable dovecot

# restart spamassassin
if [ $spamassassin = install_spamassassin ]; then
    if [ $redhat_ver = redos ]; then
        service spamassassin.service restart
        systemctl enable --now spamass-milter
    elif [ $redhat_ver != redos ]; then
        systemctl restart spamassassin.service
        systemctl enable spamassassin.service
    fi
fi
}

if [ -f "script.json" ]; then

    if ! [ "$MAKEHTTPS" = "true" ]; then
	echo "Установка Р7 Почтового сервера возможна только при HTTPS установке"
	exit 0
    fi

    echo "Install params from script."
    apt-get install -y jq
    input_file="script.json"

    InstallMailServer=`jq -r '.InstallMailServer' "$input_file"`
    MailServerDatabaseType=`jq -r '.MailServerDatabaseType' "$input_file"`
    MailServerDatabasePassword=`jq -r '.MailServerDatabasePassword' "$input_file"`
    MailServerDatabaseRootPassword=`jq -r '.MailServerDatabaseRootPassword' "$input_file"`
    MailServerMXrecord=`jq -r '.MailServerMXrecord' "$input_file"`
    MailServerIPaddress=`jq -r '.MailServerIPaddress' "$input_file"`
    InstallSPAMassassin=`jq -r '.InstallSPAMassassin' "$input_file"`
    InstallOpenDKIM=`jq -r '.InstallOpenDKIM' "$input_file"`

    echo "$InstallMailServer"
    echo "$MailServerDatabaseType"
    echo "$MailServerDatabasePassword"
    echo "$MailServerDatabaseRootPassword"
    echo "$MailServerMXrecord"
    echo "$MailServerIPaddress"
    echo "$InstallSPAMassassin"
    echo "$InstallOpenDKIM"

    if [ "$InstallMailServer" = "true" ]; then
	if [ "$MailServerDatabaseType" = "PostgreSQL" ]; then
	    hostname_in=$MailServerMXrecord
	    hostname="$hostname_in.$CDDISK_DOMAIN"
	    echo "hostname: $hostname"
	    hostnamectl set-hostname "$hostname"
	    systemctl restart systemd-hostnamed
	    ip_mail=$MailServerIPaddress
	    echo -e "\n$ip_mail $hostname_in $hostname" >> /etc/hosts
	    secret_postfix=$MailServerDatabasePassword
	    if [ "$InstallSPAMassassin" = "true" ]; then
		spamassassin="install_spamassassin"
	    else
		spamassassin="not_install_spamassassin"
	    fi
	    if [ "$InstallOpenDKIM" = "true" ]; then
		openDKIMinstall="true"
	    else
		openDKIMinstall="false"
	    fi
	    fn_install_mail_postgresql
	elif [ "$MailServerDatabaseType" = "MariaDB" ]; then
	    hostname_in=$MailServerMXrecord
	    hostname="$hostname_in.$CDDISK_DOMAIN"
	    echo "hostname: $hostname"
	    hostnamectl set-hostname "$hostname"
	    systemctl restart systemd-hostnamed
	    ip_mail=$MailServerIPaddress
	    echo -e "\n$ip_mail $hostname_in $hostname" >> /etc/hosts
	    secret_postfix=$MailServerDatabasePassword
	    secret_mysql=$MailServerDatabaseRootPassword
	    if [ "$InstallSPAMassassin" = "true" ]; then
		spamassassin="install_spamassassin"
	    else
		spamassassin="not_install_spamassassin"
	    fi
	    if [ "$InstallOpenDKIM" = "true" ]; then
		openDKIMinstall="true"
	    else
		openDKIMinstall="false"
	    fi
	    fn_install_mail_mariadb
	fi
	echo "Fix rabbitmq"
	echo "NODENAME=rabbit@$hostname" > /etc/rabbitmq/rabbitmq-env.conf
	echo "USE_LONGNAME=true" >> /etc/rabbitmq/rabbitmq-env.conf
    fi

else

    if ! [ "$MAKEHTTPS" = "true" ]; then
	whiptail --msgbox "Установка Р7 Почтового сервера возможна только при HTTPS установке" 10 60
	exit 0
    fi

    if whiptail --yesno "Установить Р7 Почтовый сервер?" 10 60; then
	choice=$(whiptail --menu "Выберите базу данных для почтового сервера:" 15 60 4 \
	    "1" "PostgreSQL" \
	    "2" "MariaDB" \
	    3>&1 1>&2 2>&3)
	case $choice in
	    1)
		fn_read_params_postgresql
		fn_install_mail_postgresql
        	;;
	    2)
		fn_read_params_mariadb
		fn_install_mail_mariadb
        	;;
	    *) 
        	echo "Неверный выбор"
        	;;
	esac
	echo "Fix rabbitmq"
	echo "NODENAME=rabbit@$hostname" > /etc/rabbitmq/rabbitmq-env.conf
	echo "USE_LONGNAME=true" >> /etc/rabbitmq/rabbitmq-env.conf
    else
	echo "Установка Р7 Почтового сервера отменена"
    fi

fi
