#!/bin/bash

input_file="/opt/r7-office/opt.json"

function read_settings_from_file
{
if [ -f $input_file ]; then
    CDDiskMakeHTTPS=`jq -r '.CDDiskMakeHTTPS' "$input_file"`
    exitstatus=$?
    if ! [ $exitstatus = 0 ];  then
        return $exitstatus
    fi
    CDDiskDomainName=`jq -r '.CDDiskDomainName' "$input_file"`
    exitstatus=$?
    if ! [ $exitstatus = 0 ];  then
        return $exitstatus
    fi
    CDDiskPrefixName=`jq -r '.CDDiskPrefixName' "$input_file"`
    exitstatus=$?
    if ! [ $exitstatus = 0 ];  then
        return $exitstatus
    fi
    AdminPrefixName=`jq -r '.AdminPrefixName' "$input_file"`
    exitstatus=$?
    if ! [ $exitstatus = 0 ];  then
        return $exitstatus
    fi
    ContactsPrefixName=`jq -r '.ContactsPrefixName' "$input_file"`
    exitstatus=$?
    if ! [ $exitstatus = 0 ];  then
        return $exitstatus
    fi
    CDMailPrefixName=`jq -r '.CDMailPrefixName' "$input_file"`
    exitstatus=$?
    if ! [ $exitstatus = 0 ];  then
        return $exitstatus
    fi
    CalendarPrefixName=`jq -r '.CalendarPrefixName' "$input_file"`
    exitstatus=$?
    if ! [ $exitstatus = 0 ];  then
        return $exitstatus
    fi
    DSPrefixName=`jq -r '.DSPrefixName' "$input_file"`
    exitstatus=$?
    if ! [ $exitstatus = 0 ];  then
        return $exitstatus
    fi
    ProjectsPrefixName=`jq -r '.ProjectsPrefixName' "$input_file"`
    exitstatus=$?
    if ! [ $exitstatus = 0 ];  then
        return $exitstatus
    fi
    PagesPrefixName=`jq -r '.PagesPrefixName' "$input_file"`
    exitstatus=$?
    if ! [ $exitstatus = 0 ];  then
        return $exitstatus
    fi
    FormsPrefixName=`jq -r '.FormsPrefixName' "$input_file"`
    exitstatus=$?
    if ! [ $exitstatus = 0 ];  then
        return $exitstatus
    fi
    echo "read file ok"
    MAKE_HTTPS=$CDDiskMakeHTTPS
    LOCAL_SITE_DOMAIN=$CDDiskDomainName
    PREFIX=$CDDiskPrefixName
    ADMIN_PREFIX=$AdminPrefixName
    CONTACTS_PREFIX=$ContactsPrefixName
    PROJECTS_PREFIX=$ProjectsPrefixName
    CDMAIL_PREFIX=$CDMailPrefixName
    CALENDAR_PREFIX=$CalendarPrefixName
    return 0
else
    return 1
fi
}

read_settings_from_file
exitstatus=$?
if ! [ $exitstatus = 0 ];  then
    echo "Ошибка открытия файла настроек $input_file, код ошибки $exitstatus"

    LOCAL_SITE_DOMAIN=$(whiptail --title  "Проверка установки" --inputbox  "Domain :" 10 60 local.ru 3>&1 1>&2 2>&3)
    exitstatus=$?
    if ! [ $exitstatus = 0 ];  then
        $LOCAL_SITE_DOMAIN = "local.ru"
    fi

    if (whiptail --title "Проверка установки" --yesno "Make HTTPS?" 10 60); then
        MAKE_HTTPS=true;
    else
        MAKE_HTTPS=false;
    fi

    PREFIX=$(whiptail --title  "Проверка установки" --inputbox  "Prefix for cddisk:" 10 60 cddisk 3>&1 1>&2 2>&3)
    exitstatus=$?
    if ! [ $exitstatus = 0 ];  then
        $PREFIX = "cddisk"
    fi

    ADMIN_PREFIX=$(whiptail --title  "Проверка установки" --inputbox  "Prefix for admin:" 10 60 admin 3>&1 1>&2 2>&3)
    exitstatus=$?
    if ! [ $exitstatus = 0 ];  then
        $ADMIN_PREFIX = "admin"
    fi

    CONTACTS_PREFIX=$(whiptail --title  "Проверка установки" --inputbox  "Prefix for contacts:" 10 60 contacts 3>&1 1>&2 2>&3)
    exitstatus=$?
    if ! [ $exitstatus = 0 ];  then
        $CONTACTS_PREFIX = "contacts"
    fi

    PROJECTS_PREFIX=$(whiptail --title  "Проверка установки" --inputbox  "Prefix for projects:" 10 60 projects 3>&1 1>&2 2>&3)
    exitstatus=$?
    if ! [ $exitstatus = 0 ];  then
        $PROJECTS_PREFIX = "projects"
    fi

    if [ $MAKE_HTTPS = true ]; then
        PagesPrefixName=$(whiptail --title  "Проверка установки" --inputbox  "Prefix for pages:" 10 60 pages 3>&1 1>&2 2>&3)
	exitstatus=$?
        if ! [ $exitstatus = 0 ];  then
	    $PagesPrefixName = "pages"
        fi
        
	FormsPrefixName=$(whiptail --title  "Проверка установки" --inputbox  "Prefix for forms:" 10 60 forms 3>&1 1>&2 2>&3)
	exitstatus=$?
        if ! [ $exitstatus = 0 ];  then
	    $FormsPrefixName = "forms"
        fi
    fi
    
    CDMAIL_PREFIX=$(whiptail --title  "Проверка установки" --inputbox  "Prefix for cdmail:" 10 60 cdmail 3>&1 1>&2 2>&3)
    exitstatus=$?
    if ! [ $exitstatus = 0 ];  then
        $CDMAIL_PREFIX = "cdmail"
    fi

    CALENDAR_PREFIX=$(whiptail --title  "Проверка установки" --inputbox  "Prefix for calendar:" 10 60 calendar 3>&1 1>&2 2>&3)
    exitstatus=$?
    if ! [ $exitstatus = 0 ];  then
        $CALENDAR_PREFIX = "calendar"
    fi
fi

echo "MAKE_HTTPS=$MAKE_HTTPS"
echo "cddisk site domain: $LOCAL_SITE_DOMAIN"
echo "cddisk prefix: $PREFIX"
echo "admin prefix: $ADMIN_PREFIX"
echo "contacts prefix: $CONTACTS_PREFIX"
echo "projects prefix: $PROJECTS_PREFIX"
echo "pages prefix: $PagesPrefixName"
echo "forms prefix: $FormsPrefixName"
echo "cdmail prefix: $CDMAIL_PREFIX"
echo "calendar prefix: $CALENDAR_PREFIX"

HAVE_ERROR="false"


echo "Пауза 30 секунд для ожидания запуска сервисов"
sleep 30

echo "Сервисы, которые неактивны или не включены при запуске:"

for name in ds-metrics ds-converter ds-docservice supervisord postgresql rabbitmq-server redis nginx; do
    isActive=$(systemctl is-active ${name})
    isEnabled=$(systemctl is-enabled ${name})

    if [ "$isActive" == "inactive" ] || [ "$isEnabled" == "disabled" ]; then
        echo "Сервис: ${name}"
        echo "  Активность: $isActive"
        echo "  Автозапуск: $isEnabled"
	HAVE_ERROR="true"
	echo -e "\e[31m❌ Ошибка  \e[0m"
    fi
done

echo "Введите пароль администратора для контроля наличия лог-файлов"
sudo /opt/r7-office/r7-logcheck.sh
if [ $? -ne 0 ]; then
	HAVE_ERROR="true"
fi
if [ -f /opt/r7-office/rabbitmqpass ]; then
    rqpass=$(sudo cat /opt/r7-office/rabbitmqpass)
    sudo rabbitmqctl add_user team $rqpass
    sudo rabbitmqctl set_user_tags team administrator
    sudo rabbitmqctl set_permissions -p / team ".*" ".*" ".*"  
    sudo rm -f /opt/r7-office/rabbitmqpass
fi

base_domain=$LOCAL_SITE_DOMAIN

sites=(
"$base_domain"
"$ADMIN_PREFIX.$base_domain"
"$PREFIX.$base_domain"
"$CONTACTS_PREFIX.$base_domain"
"$CALENDAR_PREFIX.$base_domain"
"$CDMAIL_PREFIX.$base_domain"
"$PROJECTS_PREFIX.$base_domain"
)

for site in "${sites[@]}"; do
    if [ "$MAKE_HTTPS" = "true" ]; then
        response_code=$(curl -o /dev/null -s -w "%{http_code}" "https://$site")
    else
        response_code=$(curl -o /dev/null -s -w "%{http_code}" "http://$site")
    fi

    if [[ $response_code -eq 200 ]]; then
        echo "Сайт $site успешно открывается."
    else
        echo "Сайт $site не открывается или возвращает код ошибки: $response_code"
        HAVE_ERROR="true"
	echo -e "\e[31m❌ Ошибка  \e[0m"
    fi
done

if [ $MAKE_HTTPS = "true" ]; then
endpoints=(
"https://$PREFIX.$base_domain/api/v1/version"
"https://$ADMIN_PREFIX.$base_domain/api/v1/version"
"https://$CONTACTS_PREFIX.$base_domain/api/v1/version"
"https://$CDMAIL_PREFIX.$base_domain/api/v1/version"
"https://$CALENDAR_PREFIX.$base_domain/api/v1/version"
"https://$PROJECTS_PREFIX.$base_domain/api/v1/version"
)
else
endpoints=(
"http://$PREFIX.$base_domain/api/v1/version"
"http://$ADMIN_PREFIX.$base_domain/api/v1/version"
"http://$CONTACTS_PREFIX.$base_domain/api/v1/version"
"http://$CDMAIL_PREFIX.$base_domain/api/v1/version"
"http://$CALENDAR_PREFIX.$base_domain/api/v1/version"
"http://$PROJECTS_PREFIX.$base_domain/api/v1/version"
)
fi

for endpoint in "${endpoints[@]}"; do
    echo "Проверка $endpoint ..."
    
    response=$(curl -s "$endpoint")

    # Проверка на наличие ошибок в запросе
    if [[ $? -eq 0 ]]; then
        version=$(echo $response | /opt/r7-office/installtools/json Version)
        name=$(echo $response | /opt/r7-office/installtools/json Name)
        copyright=$(echo $response | /opt/r7-office/installtools/json Copyrigth)
        
        echo "Имя: $name"
        echo "Версия: $version"
        echo "Авторские права: $copyright"
        if [ -z "${oldname}" ] && [ -z "${oldversion}" ] && [ -z "${oldcopyright}" ] ; then
            oldname="${name}"
            oldversion="${version}"
            oldcopyright="${copyright}"
        else
            if [ "${oldname}" != "${name}" ];then
	        echo "Не совпадает имя ${oldname} != ${name}"
		HAVE_ERROR="true"
		echo -e "\e[31m❌ Ошибка  \e[0m"
            fi
            if [ "${oldversion}" != "${version}" ];then
	        echo "Не совпадает версия ${oldversion} != ${version}"
		HAVE_ERROR="true"
		echo -e "\e[31m❌ Ошибка  \e[0m"
            fi
            if [ "${oldcopyright}" != "${copyright}" ];then
	        echo "Не совпадает версия ${oldcopyright} != ${copyright}"
		HAVE_ERROR="true"
		echo -e "\e[31m❌ Ошибка  \e[0m"
            fi
        fi
    else
        echo "Ошибка при доступе к $endpoint"
        HAVE_ERROR="true"
	echo -e "\e[31m❌ Ошибка  \e[0m"
    fi
    echo "---------------------------"
done

if [ $HAVE_ERROR = "true" ]; then
echo -e "\e[31m❌ Ошибка  \e[0m"
echo "-----------------------------------------"
echo "|                                       |"
echo "|  Если возникла ошибка или нужна       |"
echo "|  помощь, обратитесь:                  |"
echo "|  support@r7-office.ru                 |"
echo "|                                       |"
echo "|  С уважением к Вам,                   |"
echo "|  Команда Р7                           |"
echo "|                                       |"
echo "-----------------------------------------"
echo -e "\nЧтобы получить доступ откройте в браузере:"
echo "Логин и пароль администратора superadmin superadmin"
if [ $MAKE_HTTPS = "true" ]; then
    echo "Админ: https://$ADMIN_PREFIX.$base_domain"
    echo "Диск: https://$PREFIX.$base_domain"
    echo "Контакты: https://$CONTACTS_PREFIX.$base_domain"
    echo "Календарь: https://$CALENDAR_PREFIX.$base_domain"
    echo "Почта: https://$CDMAIL_PREFIX.$base_domain"
    echo "Проекты: https://$PROJECTS_PREFIX.$base_domain"
    echo "Страницы: https://$PagesPrefixName.$base_domain"
    echo "Формы: https://$FormsPrefixName.$base_domain"
else
    echo "Админ: http://$ADMIN_PREFIX.$base_domain"
    echo "Диск: http://$PREFIX.$base_domain"
    echo "Контакты: http://$CONTACTS_PREFIX.$base_domain"
    echo "Календарь: http://$CALENDAR_PREFIX.$base_domain"
    echo "Почта: http://$CDMAIL_PREFIX.$base_domain"
    echo "Проекты: http://$PROJECTS_PREFIX.$base_domain"
fi
else
echo -e "\e[32m✅ Установка прошла успешно  \e[0m"
# Приветственное сообщение
echo -e "\nЧтобы получить доступ откройте в браузере:"
echo "Логин и пароль администратора superadmin superadmin"
if [ $MAKE_HTTPS = "true" ]; then
    echo "Админ: https://$ADMIN_PREFIX.$base_domain"
    echo "Диск: https://$PREFIX.$base_domain"
    echo "Контакты: https://$CONTACTS_PREFIX.$base_domain"
    echo "Календарь: https://$CALENDAR_PREFIX.$base_domain"
    echo "Почта: https://$CDMAIL_PREFIX.$base_domain"
    echo "Проекты: https://$PROJECTS_PREFIX.$base_domain"
    echo "Страницы: https://$PagesPrefixName.$base_domain"
    echo "Формы: https://$FormsPrefixName.$base_domain"
else
    echo "Админ: http://$ADMIN_PREFIX.$base_domain"
    echo "Диск: http://$PREFIX.$base_domain"
    echo "Контакты: http://$CONTACTS_PREFIX.$base_domain"
    echo "Календарь: http://$CALENDAR_PREFIX.$base_domain"
    echo "Почта: http://$CDMAIL_PREFIX.$base_domain"
    echo "Проекты: http://$PROJECTS_PREFIX.$base_domain"
fi
fi

read -p "Для удаления автоматической проверки введите пароль администратора. Нажмите ENTER для продолжения" answer

sudo rm -f /etc/xdg/autostart/r7-healcheck.desktop 
