#/bin/bash

##################################################################################
##################################################################################
REMOVE_DB=0
REMOVE_FILES=0
##################################################################################
##################################################################################

RABBITMQ_INSTALLED=0
PG_SERVER_INSTALLED=0
PG_CLIENT_INSTALLED=0
DS_DEPENDENCIES_INSTALLED=0
DS_INSTALLED=0
DS_EXTERNAL_INSTALLED=0
CDDISK_DEPENDENCIES_INSTALLED=0
CDDISK_INSTALLED=0
CDDISK_ONLY_INSTALLATION=0
CDMAIL_INSTALLED=0
CALENDAR_INSTALLED=0

resultFunc=0

OS_NAME="unknown"
OS_VERSION_HI=""
OS_VERSION_LOW=""


fn_result_print()
{
    echo "RABBITMQ_INSTALLED=$RABBITMQ_INSTALLED"
    echo "PG_SERVER_INSTALLED=$PG_SERVER_INSTALLED"
    echo "PG_CLIENT_INSTALLED=$PG_CLIENT_INSTALLED"
    echo "DS_DEPENDENCIES_INSTALLED=$DS_DEPENDENCIES_INSTALLED"
    echo "DS_INSTALLED=$DS_INSTALLED"
    echo "DS_EXTERNAL_INSTALLED=$DS_EXTERNAL_INSTALLED"
    echo "CDDISK_DEPENDENCIES_INSTALLED=$CDDISK_DEPENDENCIES_INSTALLED"
    echo "CDDISK_INSTALLED=$CDDISK_INSTALLED"
    echo "CDDISK_ONLY_INSTALLATION=$CDDISK_ONLY_INSTALLATION"
    echo "CDMAIL_INSTALLED=$CDMAIL_INSTALLED"
    echo "CALENDAR_INSTALLED=$CALENDAR_INSTALLED"
    if [ -f opt.json ]; then
	rm opt.json
    fi
    echo "{" >> opt.json
    echo "	\"RABBITMQ_INSTALLED\":$RABBITMQ_INSTALLED," >> opt.json
    echo "	\"PG_SERVER_INSTALLED\":$PG_SERVER_INSTALLED," >> opt.json
    echo "	\"PG_CLIENT_INSTALLED\":$PG_CLIENT_INSTALLED," >> opt.json
    echo "	\"DS_DEPENDENCIES_INSTALLED\":$DS_DEPENDENCIES_INSTALLED," >> opt.json
    echo "	\"DS_INSTALLED\":$DS_INSTALLED," >> opt.json
    echo "	\"DS_EXTERNAL_INSTALLED\":$DS_EXTERNAL_INSTALLED," >> opt.json
    echo "	\"CDDISK_DEPENDENCIES_INSTALLED\":$CDDISK_DEPENDENCIES_INSTALLED," >> opt.json
    echo "	\"CDDISK_INSTALLED\":$CDDISK_INSTALLED," >> opt.json
    echo "	\"CDDISK_ONLY_INSTALLATION\":$CDDISK_ONLY_INSTALLATION," >> opt.json
    echo "	\"CDMAIL_INSTALLED\":$CDMAIL_INSTALLED," >> opt.json
    echo "	\"CALENDAR_INSTALLED\":$CALENDAR_INSTALLED" >> opt.json
    echo "}" >> opt.json
}

fn_check_result_write_exit()
{
    if ! [ $resultFunc = 0 ]; then
	echo "Error $resultFunc. Exit uninstallation."
	fn_result_print
    fi
}

fn_remove_rabbitmq()
{
    resultFunc=0
    echo "Removing rabbitmq server."
    dnf remove -y rabbitmq-server
    resultFunc="$?"
    if [ $resultFunc = 0 ]; then
	RABBITMQ_INSTALLED=0
    fi
}

fn_remove_pg_server()
{
    resultFunc=0
    echo "Removing postgresql server."
    dnf remove -y postgresql-server
    resultFunc="$?"
    if [ $resultFunc = 0 ]; then
	PG_SERVER_INSTALLED=0
	if [ $REMOVE_DB = 1 ]; then
	    rm -f -r /var/lib/pgsql/data
	fi
    fi
}

fn_remove_pg_client()
{
    resultFunc=0
    echo "Removing postgresql client."
    dnf remove -y postgresql
    resultFunc="$?"
    if [ $resultFunc = 0 ]; then
	PG_CLIENT_INSTALLED=0
    fi
}

fn_remove_ds()
{
    resultFunc=0
    echo "Removing Document Server."
    dnf remove -y r7-office-documentserver-ee
    resultFunc="$?"
    if [ $resultFunc = 0 ]; then
	DS_INSTALLED=0
    fi
}

fn_remove_ds_ext()
{
    resultFunc=0
    echo "Removing Document Builder."
    dnf remove -y r7-office-documentbuilder
    resultFunc="$?"
    if [ $resultFunc = 0 ]; then
	DS_EXTERNAL_INSTALLED=0
    fi
}

fn_remove_cddisk()
{
    resultFunc=0
    echo "Removing cddisk."
    dnf remove -y cddisk
    resultFunc="$?"
    if [ $resultFunc = 0 ]; then
	CDDISK_INSTALLED=0
    fi
    rm -f /etc/nginx/conf.d/admin-site.conf
    rm -f /etc/nginx/conf.d/cddisk.conf
    rm -f /etc/nginx/conf.d/cddisk-site.conf
    rm -f /etc/nginx/conf.d/contacts-site.conf
}

fn_remove_calendar()
{
    resultFunc=0
    echo "Removing calendar."
    dnf remove -y calendar
    resultFunc="$?"
    if [ $resultFunc = 0 ]; then
	CALENDAR_INSTALLED=0
    fi
    rm -f /etc/nginx/conf.d/calendar.conf
}

fn_remove_cdmail()
{
    resultFunc=0
    echo "Removing cdmail."
    dnf remove -y cdmail
    resultFunc="$?"
    if [ $resultFunc = 0 ]; then
	CDMAIL_INSTALLED=0
    fi
    rm -f /etc/nginx/conf.d/cdmail.conf
}

fn_remove_files_db()
{
    if [ $REMOVE_FILES = 1 ]; then
	rm -r -f /etc/r7-office
	rm -r -f /opt/r7-office
	rm -r -f /var/r7-office
	rm -r -f /var/lib/r7-office
	rm -r -f /var/www/r7-office
	rm -r -f /var/log/r7-office
    fi
}

fn_main_uninstall()
{
input_file="opt.json"
if [ -f "$input_file" ]; then
    echo "Uninstall params from script."
    dnf install -y jq

    RABBITMQ_INSTALLED=`jq -r '.RABBITMQ_INSTALLED' "$input_file"`
    PG_SERVER_INSTALLED=`jq -r '.PG_SERVER_INSTALLED' "$input_file"` 
    PG_CLIENT_INSTALLED=`jq -r '.PG_CLIENT_INSTALLED' "$input_file"`
    DS_DEPENDENCIES_INSTALLED=`jq -r '.DS_DEPENDENCIES_INSTALLED' "$input_file"`
    DS_INSTALLED=`jq -r '.DS_INSTALLED' "$input_file"`
    DS_EXTERNAL_INSTALLED=`jq -r '.DS_EXTERNAL_INSTALLED' "$input_file"`
    CDDISK_DEPENDENCIES_INSTALLED=`jq -r '.CDDISK_DEPENDENCIES_INSTALLED' "$input_file"`
    CDDISK_INSTALLED=`jq -r '.CDDISK_INSTALLED' "$input_file"`
    CDDISK_ONLY_INSTALLATION=`jq -r '.CDDISK_ONLY_INSTALLATION' "$input_file"`
    CDMAIL_INSTALLED=`jq -r '.CDMAIL_INSTALLED' "$input_file"`
    CALENDAR_INSTALLED=`jq -r '.CALENDAR_INSTALLED' "$input_file"`

    echo "RABBITMQ_INSTALLED=$RABBITMQ_INSTALLED"
    echo "PG_SERVER_INSTALLED=$PG_SERVER_INSTALLED"
    echo "PG_CLIENT_INSTALLED=$PG_CLIENT_INSTALLED"
    echo "DS_DEPENDENCIES_INSTALLED=$DS_DEPENDENCIES_INSTALLED"
    echo "DS_INSTALLED=$DS_INSTALLED"
    echo "DS_EXTERNAL_INSTALLED=$DS_EXTERNAL_INSTALLED"
    echo "CDDISK_DEPENDENCIES_INSTALLED=$CDDISK_DEPENDENCIES_INSTALLED"
    echo "CDDISK_INSTALLED=$CDDISK_INSTALLED"
    echo "CDDISK_ONLY_INSTALLATION=$CDDISK_ONLY_INSTALLATION"
    echo "CDMAIL_INSTALLED=$CDMAIL_INSTALLED"
    echo "CALENDAR_INSTALLED=$CALENDAR_INSTALLED"

    if [ "$CDDISK_INSTALLED" = "1" ]; then
	if [ "$CALENDAR_INSTALLED" = "1" ]; then
	    fn_remove_calendar
	    fn_check_result_write_exit
	fi
	if [ "$CDMAIL_INSTALLED" = "1" ]; then
	    fn_remove_cdmail
	    fn_check_result_write_exit
	fi
	if [ "$CDDISK_INSTALLED" = "1" ]; then
	    fn_remove_cddisk
	    fn_check_result_write_exit
	fi
	CDDISK_DEPENDENCIES_INSTALLED=0
    fi
    if [ "$DS_INSTALLED" = "1" ]; then
	fn_remove_ds
	fn_check_result_write_exit
    fi
    if [ "$DS_EXTERNAL_INSTALLED" = "1" ]; then
	fn_remove_ds_ext
	fn_check_result_write_exit
    fi
    if [ "$PG_CLIENT_INSTALLED" = "1" ]; then
	fn_remove_pg_client
	fn_check_result_write_exit
    fi
    if [ "$PG_SERVER_INSTALLED" = "1" ]; then
	fn_remove_pg_server
	fn_check_result_write_exit
    fi
    if [ "$RABBITMQ_INSTALLED" = "1" ]; then
	fn_remove_rabbitmq
	fn_check_result_write_exit
    fi
    DS_DEPENDENCIES_INSTALLED=0
    fn_remove_files_db
    fn_result_print
else
    echo "Install params file $input_file not found."
fi
}

fn_uninstall()
{
    fn_main_uninstall
    finstallResult=$?
    if [ $resultFunc = 0 ]; then
	echo "CDDisk uninstall complete."
    else
	echo "CDDisk uninstall failed. Exit code $resultFunc"
    fi
}

fn_uninstall 2>&1 | tee -a logfile.txt
