#!/bin/bash

HAVE_ERROR="false"

# Определите папки для проверки
directories=(
"/var/log/r7-office/documentserver/converter"
"/var/log/r7-office/documentserver/docservice"
"/var/log/r7-office/documentserver/metrics"
"/var/log/r7-office/CDDisk/Api"
"/var/log/r7-office/CDDisk/FileStorage"
"/var/log/r7-office/CDDisk/Processing"
"/var/log/r7-office/CDDisk/R7.Storage.Server.Api.Host"
"/var/log/r7-office/CDDisk/SearchApi"
"/var/log/r7-office/CDDisk/R7.Storage.Server.Processing.Host"
"/var/log/r7-office/CDDisk/Service.Registry"
"/var/log/nginx"
"/var/log/rabbitmq"
"/var/log/redis"
"/var/log/supervisor"
)

for dir in "${directories[@]}"; do
    # Проверка существования папки
    if [[ -d $dir ]]; then
        echo "Папка $dir существует."

        # Проверка на наличие лог-файлов в папке
        log_files=($(find $dir -type f -name "*.log"))
        if [[ ${#log_files[@]} -gt 0 ]]; then
            echo "Лог-файлы в $dir:"
            for log in "${log_files[@]}"; do
                echo "  $log"
            done
        else
            echo "В папке $dir лог-файлы отсутствуют."
            HAVE_ERROR="true"
	    echo -e "\e[31m❌ Ошибка  \e[0m"
        fi
    else
        echo "Папка $dir не существует!"
        HAVE_ERROR="true"
	echo -e "\e[31m❌ Ошибка  \e[0m"
    fi
done

if [ ${HAVE_ERROR} = "true" ]; then
exit 1
else
exit 0
fi
