#!/bin/bash

DB_HOST=$(grep -oP "host=[^\";]*" /etc/dovecot/dovecot-pgsql.conf | head -1 | cut -d'=' -f2 | cut -d' ' -f1)
DB_USER=$(grep -oP "user=[^\";]*" /etc/dovecot/dovecot-pgsql.conf | head -1 | cut -d'=' -f2 | cut -d' ' -f1)
DB_PASS=$(grep -oP "password=[^\";]*" /etc/dovecot/dovecot-pgsql.conf | head -1 | cut -d'=' -f2 | cut -d' ' -f1)
DB_NAME=$(grep -oP "dbname=[^\";]*" /etc/dovecot/dovecot-pgsql.conf | head -1 | cut -d'=' -f2 | cut -d' ' -f1)
DB_PORT=5432

ALIAS_OLD=$1
ALIAS_NEW=$2

# Проверяем наличие алиаса в базе
result=$(psql -h $DB_HOST -U $DB_USER -d $DB_NAME -p $DB_PORT -t -c "SELECT COUNT(*) FROM virtual_aliases WHERE source='$ALIAS_OLD'")
if [ "$result" -eq 0 ]; then
    echo "Алиас не найден"
    exit 1
fi

# Переводим новое название алиаса в нижний регистр
ALIAS_NEW=$(echo "$ALIAS_NEW" | tr '[:upper:]' '[:lower:]')

# Обновляем адрес назначения в базе
if psql -h $DB_HOST -U $DB_USER -d $DB_NAME -p $DB_PORT -c "UPDATE virtual_aliases SET destination='$ALIAS_NEW' WHERE source='$ALIAS_OLD'"; then
    echo "Алиас успешно обновлен"
else
    echo "Ошибка SQL-запроса"
    exit 1
fi