#!/bin/bash

DB_HOST=$(grep -oP "host=[^\";]*" /etc/dovecot/dovecot-pgsql.conf | head -1 | cut -d'=' -f2 | cut -d' ' -f1)
DB_USER=$(grep -oP "user=[^\";]*" /etc/dovecot/dovecot-pgsql.conf | head -1 | cut -d'=' -f2 | cut -d' ' -f1)
DB_PASS=$(grep -oP "password=[^\";]*" /etc/dovecot/dovecot-pgsql.conf | head -1 | cut -d'=' -f2 | cut -d' ' -f1)
DB_NAME=$(grep -oP "dbname=[^\";]*" /etc/dovecot/dovecot-pgsql.conf | head -1 | cut -d'=' -f2 | cut -d' ' -f1)
DB_PORT=5432

# Минимальная длина пароля
PASSWORD_MIN_LENGTH=8

# Функция для проверки существования пользователя в базе данных
function check_user {
    local email=$1
    local query="SELECT COUNT(*) FROM virtual_users WHERE email='$email'"
    local result=$(psql -h $DB_HOST -U $DB_USER -d $DB_NAME -p $DB_PORT -t -c "$query")

    if [ "$result" -eq 0 ]; then
        echo "Пользователь $email не найден в базе данных"
        return 1
    fi
}

# Функция для проверки сложности нового пароля
function check_password {
    local password=$1

    # Проверка длины пароля
    local length=${#password}
    if [ "$length" -lt "$PASSWORD_MIN_LENGTH" ]; then
        echo "Пароль должен быть не менее $PASSWORD_MIN_LENGTH символов"
        return 1
    fi

    # Проверка наличия цифр и букв
    if ! [[ "$password" =~ [0-9] && "$password" =~ [A-Za-z] ]]; then
        echo "Пароль должен содержать цифры и буквы"
        return 1
    fi
}

# Функция для изменения пароля пользователя в базе данных
function change_password {
    local email=$1
    local password_hash=$(sudo doveadm pw -s 'ssha512' -p "$2")
    local query="UPDATE virtual_users SET password='$password_hash' WHERE email='$email'"

    if psql -h $DB_HOST -U $DB_USER -d $DB_NAME -p $DB_PORT -c "$query"; then
        echo "Пароль пользователя $email успешно изменен"
    else
        echo "Ошибка при изменении пароля пользователя $email"
        return 1
    fi
}

# Запрос email пользователя
# read -p "Введите email пользователя: " email

email=$1

# Проверка наличия пользователя в базе данных
if ! check_user "$email"; then
    exit 1
fi

# Запрос нового пароля
# read -p "Введите новый пароль: " password

password=$2

# Проверка сложности нового пароля
if ! check_password "$password"; then
    exit 1
fi

# Изменение пароля в базе данных
if ! change_password "$email" "$password"; then
    exit 1
fi