#!/bin/bash

DB_HOST=$(grep -oP "host=[^\";]*" /etc/dovecot/dovecot-pgsql.conf | head -1 | cut -d'=' -f2 | cut -d' ' -f1)
DB_USER=$(grep -oP "user=[^\";]*" /etc/dovecot/dovecot-pgsql.conf | head -1 | cut -d'=' -f2 | cut -d' ' -f1)
DB_PASS=$(grep -oP "password=[^\";]*" /etc/dovecot/dovecot-pgsql.conf | head -1 | cut -d'=' -f2 | cut -d' ' -f1)
DB_NAME=$(grep -oP "dbname=[^\";]*" /etc/dovecot/dovecot-pgsql.conf | head -1 | cut -d'=' -f2 | cut -d' ' -f1)
DB_PORT=5432

function get_next_domain_id {
    # Получить следующий доступный ID для домена
    next_id=$(psql -h $DB_HOST -U $DB_USER -d $DB_NAME -p $DB_PORT -t -c "SELECT MAX(id) + 1 FROM virtual_domains")
    if [ -z "$next_id" ]; then
        next_id=1
    fi
    echo "$next_id"
}

function check_domain {
    # Проверка наличия домена в таблице
    result=$(psql -h $DB_HOST -U $DB_USER -d $DB_NAME -p $DB_PORT -t -c "SELECT COUNT(*) FROM virtual_domains WHERE name='$1'")
    if [ "$result" -gt 0 ]; then
        echo "Домен уже существует"
        return 1
    fi
}

function add_domain {
    # Проверка домена на наличие и правильность
    NEW_DOMAIN=$1
    if [ -z "$NEW_DOMAIN" ]; then
        echo "Домен не указан"
        return 1
    fi

    NEW_DOMAIN=$(echo "$NEW_DOMAIN" | tr '[:upper:]' '[:lower:]')  # Переводим домен в нижний регистр

    if ! check_domain "$NEW_DOMAIN"; then
        return 1
    fi

    next_id=$(get_next_domain_id)

    if psql -h $DB_HOST -U $DB_USER -d $DB_NAME -p $DB_PORT -c "INSERT INTO virtual_domains (id, name) VALUES ('$next_id', '$NEW_DOMAIN')"; then
        echo "Домен добавлен"
        # Выполнение дополнительные действий, для адаптации с OpenDKIM
        mkdir -p /etc/opendkim/keys/"$NEW_DOMAIN"
        opendkim-genkey -b 1024 --directory /etc/opendkim/keys/"$NEW_DOMAIN"/ --domain "$NEW_DOMAIN" --selector dkim
        chown -R opendkim:opendkim /etc/opendkim/keys/"$NEW_DOMAIN"
        echo "*.$NEW_DOMAIN" >> /etc/opendkim/TrustedHosts
        echo "dkim._domainkey.$NEW_DOMAIN $NEW_DOMAIN:dkim:/etc/opendkim/keys/$NEW_DOMAIN/dkim.private" >> /etc/opendkim/KeyTable
        echo "*@$NEW_DOMAIN dkim._domainkey.$NEW_DOMAIN" >> /etc/opendkim/SigningTable
        systemctl restart opendkim
        systemctl restart postfix
        cat "/etc/opendkim/keys/$NEW_DOMAIN/dkim.txt"
    else
        echo "Ошибка SQL-запроса"
        return 1
    fi
}

add_domain "$1"