
DO $$ 
    BEGIN
         IF EXISTS (SELECT "Id" FROM public."Versions" WHERE "Build">=4333) THEN
		RETURN;
          END IF;
 
        BEGIN
  
CREATE TABLE IF NOT EXISTS public."LicenseCodes"
(
    "Id" bigserial NOT NULL,
    "Code" character varying(512) NOT NULL,
    "ProductType" character varying(4000) NOT NULL,
    "AvailableActivations" int NOT NULL,
    "UsageCount" int NOT NULL,    
    "Timestamp" timestamp without time zone NOT NULL DEFAULT timezone('utc'::text, now()),
    "OwnerId" bigint NOT NULL,
    "CustomerId" int not null,    
    CONSTRAINT "LicenseCodes_pkey" PRIMARY KEY ("Code")
);
 
 

CREATE INDEX IF NOT EXISTS "IDX_LicenseCodes-CustomerId-OwnerId"
    ON public."LicenseCodes" USING btree
    ("CustomerId" ASC NULLS LAST, "OwnerId" ASC NULLS LAST)
    TABLESPACE pg_default;
  
        EXCEPTION
            WHEN duplicate_table THEN RAISE NOTICE 'Can not Create table <LicenseCodes>.';
        END;
    END;
$$









