DO $$ 
	DECLARE _path character varying(256) = 'patch-2024-08-26-ProjectTask_HasChildren';

	BEGIN
		IF EXISTS (SELECT "Id" FROM public."Versions" WHERE "Path"=_path) THEN
			RETURN;
		END IF;

		IF EXISTS (SELECT "Id" FROM public."Versions" WHERE "Build">=14252) THEN
			RETURN;
		END IF;

		BEGIN
			ALTER TABLE public."ProjectTasks" ADD "HasChildren" boolean DEFAULT false;
			UPDATE public."ProjectTasks" SET "HasChildren"=True where EXISTS(SELECT "Id" FROM public."ProjectTasks" pt where pt."ParentId"=public."ProjectTasks"."Id");
 			INSERT INTO public."Versions" ("Path", "Build") VALUES (_path, 0);
			EXCEPTION
				WHEN OTHERS THEN RAISE NOTICE '[ERR] patch-2024-08-26-ProjectTask_HasChildren: %', SQLERRM;
		END;
	END;
$$ 