DO $$ 
	DECLARE _path character varying(256) = 'patch-2024-08-22-TimeZones';

	BEGIN
		IF EXISTS (SELECT "Id" FROM public."Versions" WHERE "Path"=_path) THEN
			RETURN;
		END IF;

		IF EXISTS (SELECT "Id" FROM public."Versions" WHERE "Build">=14244) THEN
			RETURN;
		END IF;

		BEGIN
			ALTER TABLE public."TimeZones" ADD "Abbr" varchar(6) NULL;
			ALTER TABLE public."TimeZones" ADD "OffsetMinutes" int2 NULL;
			ALTER TABLE public."TimeZones" ADD "HasSummerOffset" boolean DEFAULT False NOT NULL;
			ALTER TABLE public."TimeZones" ADD "ZoneDescription" varchar(64) NULL;
			ALTER TABLE public."TimeZones" ADD "Version" int2 DEFAULT 0 NOT NULL;
 			INSERT INTO public."Versions" ("Path", "Build") VALUES (_path, 0);
			EXCEPTION
				WHEN OTHERS THEN RAISE NOTICE '[ERR] patch-2024-08-22-TimeZones: %', SQLERRM;
		END;
	END;
$$