DO $$ 
	DECLARE _path character varying(256) = 'patch-2024-11-14-RoleNameResize';

	BEGIN
		IF EXISTS (SELECT "Id" FROM public."Versions" WHERE "Path"=_path) THEN
			RETURN;
		END IF;

		IF EXISTS (SELECT "Id" FROM public."Versions" WHERE "Build">=14592) THEN
			RETURN;
		END IF;

		BEGIN
            		ALTER TABLE public."Roles"   ADD  "NameNew" character varying(1024);
            		UPDATE public."Roles"   SET "NameNew"="Name";
            		ALTER TABLE public."Roles" DROP "Name";
            		ALTER TABLE public."Roles" RENAME "NameNew" TO "Name";

 			INSERT INTO public."Versions" ("Path", "Build") VALUES (_path, 0);
			EXCEPTION
				WHEN OTHERS THEN RAISE NOTICE '[ERR] patch-2024-11-14-RoleNameResize: %', SQLERRM;
		END;
	END;
$$