DO $$ 
	DECLARE _path character varying(256) = 'patch-2025_03_19-ProjectTaskTypesPattern';

	BEGIN
		IF EXISTS (SELECT "Id" FROM public."Versions" WHERE "Path"=_path) THEN
			RETURN;
		END IF;

		IF EXISTS (SELECT "Id" FROM public."Versions" WHERE "Build">=15123) THEN
			RETURN;
		END IF;

		BEGIN
	
			update public."ProjectTaskTypes"  
			set "PatternId"= (SELECT pt."Id" FROM public."ProjectTaskTypes" pt where  pt."ProjectId" IS NUll AND pt."Type"=3 LIMIT 1)
			where "Name"='Задача'  AND "ProjectId" IS NOT NUll;
 

 			INSERT INTO public."Versions" ("Path", "Build") VALUES (_path, 0);
			EXCEPTION
				WHEN OTHERS THEN RAISE NOTICE '[ERR] patch-2025_03_19-ProjectTaskTypesPattern: %', SQLERRM;
		END;
	END;
$$