DO $$ 
	DECLARE _path character varying(256) = 'patch-2025_06_09-UserActionsExportSchedule';

	BEGIN
		IF EXISTS (SELECT "Id" FROM public."Versions" WHERE "Path"=_path) THEN
			RETURN;
		END IF;

		IF EXISTS (SELECT "Id" FROM public."Versions" WHERE "Build">=15110) THEN
			RETURN;
		END IF;

		BEGIN

			CREATE TABLE public."UserActionsExportSchedule" (
				"Id" bigserial PRIMARY KEY,
				"CustomerId" int NOT NULL,
				"LastActionDate" timestamp without time zone,
				"Status" int NOT NULL,
				CONSTRAINT "UIDX_UserActionsExportSchedule" UNIQUE ("CustomerId")
			);

			CREATE INDEX "IDX_UserActionsExportSchedule_CustomerId"
				ON public."UserActionsExportSchedule" USING btree
					("CustomerId" ASC NULLS LAST)
				TABLESPACE pg_default;

			INSERT INTO public."Versions" ("Path", "Build") VALUES (_path, 0);
		EXCEPTION
				WHEN OTHERS THEN RAISE NOTICE 'patch-2025_06_09-UserActionsExportSchedule: %', SQLERRM;


		END;
	END;
$$