﻿DO $$ 
	DECLARE _path character varying(256) = 'patch-2025_08_01-ProjectParentId_Indexing';

	BEGIN
		IF EXISTS (SELECT "Id" FROM public."Versions" WHERE "Path"=_path) THEN
			RETURN;
		END IF;

		IF EXISTS (SELECT "Id" FROM public."Versions" WHERE "Build">=15215) THEN
			RETURN;
		END IF;

		BEGIN
				CREATE INDEX IF NOT EXISTS "IDX_Projects-ParentId"
						ON public."Projects" USING btree
						("ParentId" ASC NULLS LAST)
						TABLESPACE pg_default;


			INSERT INTO public."Versions" ("Path", "Build") VALUES (_path, 0);

			EXCEPTION
				WHEN OTHERS THEN RAISE NOTICE 'patch-2025_08_01-ProjectParentId_Indexing: %', SQLERRM;
		END;
	END;
$$