DO $$
    DECLARE _path character varying(256) = 'patch-2025_11_01-EmailMessages_FromAccount';
BEGIN
    IF EXISTS (SELECT "Id" FROM public."Versions" WHERE "Path" = _path) THEN
        RETURN;
    END IF;

    IF EXISTS (SELECT "Id" FROM public."Versions" WHERE "Build">=15385) THEN
        RETURN;
    END IF;

    BEGIN
        ALTER TABLE public."EmailMessages" ADD COLUMN IF NOT EXISTS "FromAccount" BIGINT NULL;
        INSERT INTO public."Versions" ("Path", "Build") VALUES (_path, 0);
    EXCEPTION
        WHEN OTHERS THEN RAISE NOTICE '[ERR] %: %', _path, SQLERRM;
    END;
END;
$$;