DO $$
    DECLARE _path character varying(256) = 'patch-2025_10_08-ProjectTaskType';
    BEGIN
        IF EXISTS (SELECT "Id" FROM public."Versions" WHERE "Path"=_path) THEN
            RETURN;
        END IF;

        IF EXISTS (SELECT "Id" FROM public."Versions" WHERE "Build" >= 15456) THEN
            RETURN;
        END IF;

        BEGIN
alter table public."ProjectTaskTypes" add column IF NOT EXISTS "IsDeleted" boolean DEFAULT false NOT NULL;

            INSERT INTO public."Versions" ("Path", "Build") VALUES (_path, 0);
        EXCEPTION
            WHEN OTHERS THEN RAISE NOTICE '[ERR] %: %', _path, SQLERRM;
        END;
    END;
$$;