﻿DO $$
    DECLARE _path character varying(256) = 'patch-2025_10_13-EmailPrevFolder';
    BEGIN
        IF EXISTS (SELECT "Id" FROM public."Versions" WHERE "Path" = _path) THEN
            RETURN;
        END IF;

        IF EXISTS (SELECT "Id" FROM public."Versions" WHERE "Build" >= 15479) THEN
            RETURN;
        END IF;

        BEGIN
            CREATE INDEX IF NOT EXISTS ix_emailmessages_folder_parent_read_deleted
                ON public."EmailMessages" ("FolderId", "ParentId", "WasRead", "IsDeleted");

            INSERT INTO public."Versions" ("Path", "Build") VALUES (_path, 0);
        EXCEPTION
            WHEN OTHERS THEN RAISE NOTICE '[ERR] %: %', _path, SQLERRM;
        END;
    END;
$$;