﻿DO $$
    DECLARE
        _path character varying(256) := 'patch-2025_12_29-StorageConfigurations';
    BEGIN
        IF EXISTS (SELECT 1 FROM public."Versions" WHERE "Path" = _path) THEN
            RETURN;
        END IF;

        IF EXISTS (SELECT 1 FROM public."Versions" WHERE "Build" >= 15938) THEN
            RETURN;
        END IF;

        BEGIN
 
            ALTER TABLE public."StorageConfigurations" ADD "IsDefault" BOOLEAN NOT NULL DEFAULT(false);
	    update public."StorageConfigurations" set "IsDefault"=false;
	    update public."StorageConfigurations" set "IsDefault"=true where "Name"='default';

            INSERT INTO public."Versions" ("Path", "Build") VALUES (_path, 0);

        EXCEPTION
            WHEN OTHERS THEN
                RAISE NOTICE '[ERR] %: %', _path, SQLERRM;
        END;

    END;
$$;