CREATE TABLE public."QuotaEntityRelations" (
    "Id" bigserial NOT NULL,
    "QuotaId" integer NOT NULL,
    "EntityId" bigint NOT NULL,
    "EntityType" integer NOT NULL,
    "Timestamp" timestamp without time zone DEFAULT timezone('utc', now())  NOT NULL,
    PRIMARY KEY ("QuotaId", "EntityType", "EntityId")
);

CREATE INDEX "IDX_QuotaEntityRelations_EntityId-EntityType-OwnerId"
    ON public."QuotaEntityRelations" USING btree
    ("EntityId" ASC NULLS LAST,"EntityType" ASC NULLS LAST,"QuotaId" ASC NULLS LAST)
    TABLESPACE pg_default;
