CREATE TABLE public."UserReads" (
    "Id" bigserial NOT NULL,
    "EntityId" bigint NOT NULL,
    "Type" integer NOT NULL,
    "UserId" bigint NOT NULL,
    "Timestamp" timestamp without time zone DEFAULT timezone('utc', now())  NOT NULL,
    PRIMARY KEY ("EntityId", "UserId", "Type")
); 

CREATE INDEX "IDX_UserReads_EntityId-Type"
    ON public."UserReads" USING btree
    ("EntityId" ASC NULLS LAST, "Type" ASC NULLS LAST)
    TABLESPACE pg_default;  