CREATE TABLE public."EmailLabels"
(
	"Id" bigserial,
	"Hash" character varying(64) NOT NULL,
	"Name" character varying(256) NULL,
	"Color" character varying(50) NULL,  
	"OwnerId" BIGINT  NULL,
	"Timestamp" timestamp without time zone DEFAULT timezone('utc', now())  NOT NULL,
         CONSTRAINT "PK_EmailLabels" PRIMARY KEY("Hash")

);

CREATE INDEX "IDX_EmailLabels_OwnerId"
    ON public."EmailLabels" USING btree
    ("OwnerId" ASC NULLS LAST)
    TABLESPACE pg_default; 