CREATE TABLE public."EventMaterials" (
    "Id" bigserial NOT NULL,
    "EventId" bigint NOT NULL,
    "DocumentId" bigint NOT NULL,
    "Timestamp" timestamp without time zone DEFAULT timezone('utc', now())  NOT NULL,
  PRIMARY KEY ("EventId", "DocumentId")
); 

CREATE INDEX "IDX_EventMaterials_DocumentId"
    ON public."EventMaterials" USING btree
    ("DocumentId" ASC NULLS LAST)
    TABLESPACE pg_default; 

CREATE INDEX "IDX_EventMaterials_EventId"
    ON public."EventMaterials" USING btree
    ("EventId" ASC NULLS LAST)
    TABLESPACE pg_default; 