CREATE TABLE public."EventParticipants" (
    "Id" bigserial NOT NULL,
    "EventId" bigint NOT NULL,
    "EntityId" bigint NOT NULL,
    "EntityType" bigint NOT NULL,
    "Timestamp" timestamp without time zone DEFAULT timezone('utc', now())  NOT NULL,
    "Visit" INT NULL,
    "AccessType" INT NULL,
    PRIMARY KEY ("EntityType", "EventId", "EntityId")
);

CREATE INDEX "IDX_EventParticipants_EventId"
    ON public."EventParticipants" USING btree
    ("EventId" ASC NULLS LAST)
    TABLESPACE pg_default; 