CREATE TABLE IF NOT EXISTS public."ProjectTaskTypes"
(
    "Id" bigserial NOT NULL,
    "Name" character varying(200) NOT NULL,
    "Color" character varying(12) NOT NULL,
    "Type" integer NOT NULL,
    "Icon" character varying(128) NULL,
    "IconId" BIGINT NULL, 
    "ImageId" BIGINT NULL,
    "ProjectId" BIGINT NULL, 
    "PatternId" BIGINT NULL,
    "Order" BIGINT NULL,   
    "IsDeleted" boolean DEFAULT false NOT NULL,
    "Timestamp" timestamp without time zone NOT NULL DEFAULT timezone('utc'::text, now()),
    CONSTRAINT "ProjectTaskTypes_pkey" PRIMARY KEY ("Id")
);

CREATE UNIQUE INDEX IF NOT EXISTS "IDX_ProjectTaskTypes-ProjectId-Name"
    ON public."ProjectTaskTypes" USING btree
    ("ProjectId" ASC NULLS LAST, "Name" ASC NULLS LAST) 
    TABLESPACE pg_default where "IsDeleted" = false;
